<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomType StructType
 * @subpackage Structs
 */
class RoomType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Name
     * @var \room\StructType\DescriptionType
     */
    public $Name;
    /**
     * The Group
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Group;
    /**
     * The Configuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Configuration;
    /**
     * The Descriptions
     * @var \room\StructType\DescriptionsType
     */
    public $Descriptions;
    /**
     * The TotalOccupants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalOccupants;
    /**
     * The Occupants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\Occupants
     */
    public $Occupants;
    /**
     * The MaxInfantBeds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxInfantBeds;
    /**
     * The DisabledAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DisabledAccess;
    /**
     * The MaxNumberOfRollaways
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxNumberOfRollaways;
    /**
     * The NumberOfChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfChildren;
    /**
     * The StandardNumberOfBeds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StandardNumberOfBeds;
    /**
     * The PictureUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PictureUrl;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\FeaturesType
     */
    public $Features;
    /**
     * The RoomImages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RoomImagesType
     */
    public $RoomImages;
    /**
     * Constructor method for RoomType
     * @uses RoomType::setCode()
     * @uses RoomType::setName()
     * @uses RoomType::setGroup()
     * @uses RoomType::setConfiguration()
     * @uses RoomType::setDescriptions()
     * @uses RoomType::setTotalOccupants()
     * @uses RoomType::setOccupants()
     * @uses RoomType::setMaxInfantBeds()
     * @uses RoomType::setDisabledAccess()
     * @uses RoomType::setMaxNumberOfRollaways()
     * @uses RoomType::setNumberOfChildren()
     * @uses RoomType::setStandardNumberOfBeds()
     * @uses RoomType::setPictureUrl()
     * @uses RoomType::setFeatures()
     * @uses RoomType::setRoomImages()
     * @param string $code
     * @param \room\StructType\DescriptionType $name
     * @param string $group
     * @param string $configuration
     * @param \room\StructType\DescriptionsType $descriptions
     * @param int $totalOccupants
     * @param \room\StructType\Occupants $occupants
     * @param int $maxInfantBeds
     * @param bool $disabledAccess
     * @param int $maxNumberOfRollaways
     * @param int $numberOfChildren
     * @param int $standardNumberOfBeds
     * @param string $pictureUrl
     * @param \room\StructType\FeaturesType $features
     * @param \room\StructType\RoomImagesType $roomImages
     */
    public function __construct($code = null, \room\StructType\DescriptionType $name = null, $group = null, $configuration = null, \room\StructType\DescriptionsType $descriptions = null, $totalOccupants = null, \room\StructType\Occupants $occupants = null, $maxInfantBeds = null, $disabledAccess = null, $maxNumberOfRollaways = null, $numberOfChildren = null, $standardNumberOfBeds = null, $pictureUrl = null, \room\StructType\FeaturesType $features = null, \room\StructType\RoomImagesType $roomImages = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setGroup($group)
            ->setConfiguration($configuration)
            ->setDescriptions($descriptions)
            ->setTotalOccupants($totalOccupants)
            ->setOccupants($occupants)
            ->setMaxInfantBeds($maxInfantBeds)
            ->setDisabledAccess($disabledAccess)
            ->setMaxNumberOfRollaways($maxNumberOfRollaways)
            ->setNumberOfChildren($numberOfChildren)
            ->setStandardNumberOfBeds($standardNumberOfBeds)
            ->setPictureUrl($pictureUrl)
            ->setFeatures($features)
            ->setRoomImages($roomImages);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \room\StructType\RoomType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return \room\StructType\DescriptionType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \room\StructType\DescriptionType $name
     * @return \room\StructType\RoomType
     */
    public function setName(\room\StructType\DescriptionType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param string $group
     * @return \room\StructType\RoomType
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($group, true), gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get Configuration value
     * @return string|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param string $configuration
     * @return \room\StructType\RoomType
     */
    public function setConfiguration($configuration = null)
    {
        // validation for constraint: string
        if (!is_null($configuration) && !is_string($configuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configuration, true), gettype($configuration)), __LINE__);
        }
        $this->Configuration = $configuration;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \room\StructType\DescriptionsType|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \room\StructType\DescriptionsType $descriptions
     * @return \room\StructType\RoomType
     */
    public function setDescriptions(\room\StructType\DescriptionsType $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get TotalOccupants value
     * @return int|null
     */
    public function getTotalOccupants()
    {
        return $this->TotalOccupants;
    }
    /**
     * Set TotalOccupants value
     * @param int $totalOccupants
     * @return \room\StructType\RoomType
     */
    public function setTotalOccupants($totalOccupants = null)
    {
        // validation for constraint: int
        if (!is_null($totalOccupants) && !(is_int($totalOccupants) || ctype_digit($totalOccupants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalOccupants, true), gettype($totalOccupants)), __LINE__);
        }
        $this->TotalOccupants = $totalOccupants;
        return $this;
    }
    /**
     * Get Occupants value
     * @return \room\StructType\Occupants|null
     */
    public function getOccupants()
    {
        return $this->Occupants;
    }
    /**
     * Set Occupants value
     * @param \room\StructType\Occupants $occupants
     * @return \room\StructType\RoomType
     */
    public function setOccupants(\room\StructType\Occupants $occupants = null)
    {
        $this->Occupants = $occupants;
        return $this;
    }
    /**
     * Get MaxInfantBeds value
     * @return int|null
     */
    public function getMaxInfantBeds()
    {
        return $this->MaxInfantBeds;
    }
    /**
     * Set MaxInfantBeds value
     * @param int $maxInfantBeds
     * @return \room\StructType\RoomType
     */
    public function setMaxInfantBeds($maxInfantBeds = null)
    {
        // validation for constraint: int
        if (!is_null($maxInfantBeds) && !(is_int($maxInfantBeds) || ctype_digit($maxInfantBeds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxInfantBeds, true), gettype($maxInfantBeds)), __LINE__);
        }
        $this->MaxInfantBeds = $maxInfantBeds;
        return $this;
    }
    /**
     * Get DisabledAccess value
     * @return bool|null
     */
    public function getDisabledAccess()
    {
        return $this->DisabledAccess;
    }
    /**
     * Set DisabledAccess value
     * @param bool $disabledAccess
     * @return \room\StructType\RoomType
     */
    public function setDisabledAccess($disabledAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($disabledAccess) && !is_bool($disabledAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disabledAccess, true), gettype($disabledAccess)), __LINE__);
        }
        $this->DisabledAccess = $disabledAccess;
        return $this;
    }
    /**
     * Get MaxNumberOfRollaways value
     * @return int|null
     */
    public function getMaxNumberOfRollaways()
    {
        return $this->MaxNumberOfRollaways;
    }
    /**
     * Set MaxNumberOfRollaways value
     * @param int $maxNumberOfRollaways
     * @return \room\StructType\RoomType
     */
    public function setMaxNumberOfRollaways($maxNumberOfRollaways = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfRollaways) && !(is_int($maxNumberOfRollaways) || ctype_digit($maxNumberOfRollaways))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfRollaways, true), gettype($maxNumberOfRollaways)), __LINE__);
        }
        $this->MaxNumberOfRollaways = $maxNumberOfRollaways;
        return $this;
    }
    /**
     * Get NumberOfChildren value
     * @return int|null
     */
    public function getNumberOfChildren()
    {
        return $this->NumberOfChildren;
    }
    /**
     * Set NumberOfChildren value
     * @param int $numberOfChildren
     * @return \room\StructType\RoomType
     */
    public function setNumberOfChildren($numberOfChildren = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfChildren) && !(is_int($numberOfChildren) || ctype_digit($numberOfChildren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfChildren, true), gettype($numberOfChildren)), __LINE__);
        }
        $this->NumberOfChildren = $numberOfChildren;
        return $this;
    }
    /**
     * Get StandardNumberOfBeds value
     * @return int|null
     */
    public function getStandardNumberOfBeds()
    {
        return $this->StandardNumberOfBeds;
    }
    /**
     * Set StandardNumberOfBeds value
     * @param int $standardNumberOfBeds
     * @return \room\StructType\RoomType
     */
    public function setStandardNumberOfBeds($standardNumberOfBeds = null)
    {
        // validation for constraint: int
        if (!is_null($standardNumberOfBeds) && !(is_int($standardNumberOfBeds) || ctype_digit($standardNumberOfBeds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($standardNumberOfBeds, true), gettype($standardNumberOfBeds)), __LINE__);
        }
        $this->StandardNumberOfBeds = $standardNumberOfBeds;
        return $this;
    }
    /**
     * Get PictureUrl value
     * @return string|null
     */
    public function getPictureUrl()
    {
        return $this->PictureUrl;
    }
    /**
     * Set PictureUrl value
     * @param string $pictureUrl
     * @return \room\StructType\RoomType
     */
    public function setPictureUrl($pictureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pictureUrl) && !is_string($pictureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureUrl, true), gettype($pictureUrl)), __LINE__);
        }
        $this->PictureUrl = $pictureUrl;
        return $this;
    }
    /**
     * Get Features value
     * @return \room\StructType\FeaturesType|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \room\StructType\FeaturesType $features
     * @return \room\StructType\RoomType
     */
    public function setFeatures(\room\StructType\FeaturesType $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get RoomImages value
     * @return \room\StructType\RoomImagesType|null
     */
    public function getRoomImages()
    {
        return $this->RoomImages;
    }
    /**
     * Set RoomImages value
     * @param \room\StructType\RoomImagesType $roomImages
     * @return \room\StructType\RoomType
     */
    public function setRoomImages(\room\StructType\RoomImagesType $roomImages = null)
    {
        $this->RoomImages = $roomImages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
