<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionType StructType
 * @subpackage Structs
 */
class RestrictionType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Value
     * @var int
     */
    public $Value;
    /**
     * Constructor method for RestrictionType
     * @uses RestrictionType::setType()
     * @uses RestrictionType::setValue()
     * @param string $type
     * @param int $value
     */
    public function __construct($type = null, $value = null)
    {
        $this
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \room\EnumType\RestrictionTypeType::valueIsValid()
     * @uses \room\EnumType\RestrictionTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \room\StructType\RestrictionType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\room\EnumType\RestrictionTypeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \room\EnumType\RestrictionTypeType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \room\EnumType\RestrictionTypeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \room\StructType\RestrictionType
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RestrictionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
