<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationType StructType
 * @subpackage Structs
 */
class ReservationType extends AbstractStructBase
{
    /**
     * The HotelRef
     * @var \room\StructType\HotelRefType
     */
    public $HotelRef;
    /**
     * The ReservationType
     * @var string
     */
    public $ReservationType;
    /**
     * The BookingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingDate;
    /**
     * The CRSConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CRSConfirmationNumber;
    /**
     * The CRSConfirmationNumber2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CRSConfirmationNumber2;
    /**
     * The PromotionalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PromotionalCode;
    /**
     * The UseKeyCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseKeyCodes;
    /**
     * The RoomStays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RoomStaysType
     */
    public $RoomStays;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\ProfilesType
     */
    public $Profiles;
    /**
     * The BookerRPH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\BookerRPH
     */
    public $BookerRPH;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatus;
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\GuaranteeType
     */
    public $Guarantee;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CreditCardSurcharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CreditCardSurcharge;
    /**
     * The RoomBlockCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoomBlockCode;
    /**
     * The TicketItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\TicketItemType
     */
    public $TicketItem;
    /**
     * Constructor method for ReservationType
     * @uses ReservationType::setHotelRef()
     * @uses ReservationType::setReservationType()
     * @uses ReservationType::setBookingDate()
     * @uses ReservationType::setCRSConfirmationNumber()
     * @uses ReservationType::setCRSConfirmationNumber2()
     * @uses ReservationType::setPromotionalCode()
     * @uses ReservationType::setUseKeyCodes()
     * @uses ReservationType::setRoomStays()
     * @uses ReservationType::setProfiles()
     * @uses ReservationType::setBookerRPH()
     * @uses ReservationType::setPaymentStatus()
     * @uses ReservationType::setGuarantee()
     * @uses ReservationType::setNotes()
     * @uses ReservationType::setCreditCardSurcharge()
     * @uses ReservationType::setRoomBlockCode()
     * @uses ReservationType::setTicketItem()
     * @param \room\StructType\HotelRefType $hotelRef
     * @param string $reservationType
     * @param string $bookingDate
     * @param string $cRSConfirmationNumber
     * @param string $cRSConfirmationNumber2
     * @param string $promotionalCode
     * @param bool $useKeyCodes
     * @param \room\StructType\RoomStaysType $roomStays
     * @param \room\StructType\ProfilesType $profiles
     * @param \room\StructType\BookerRPH $bookerRPH
     * @param string $paymentStatus
     * @param \room\StructType\GuaranteeType $guarantee
     * @param string $notes
     * @param float $creditCardSurcharge
     * @param string $roomBlockCode
     * @param \room\StructType\TicketItemType $ticketItem
     */
    public function __construct(\room\StructType\HotelRefType $hotelRef = null, $reservationType = null, $bookingDate = null, $cRSConfirmationNumber = null, $cRSConfirmationNumber2 = null, $promotionalCode = null, $useKeyCodes = null, \room\StructType\RoomStaysType $roomStays = null, \room\StructType\ProfilesType $profiles = null, \room\StructType\BookerRPH $bookerRPH = null, $paymentStatus = null, \room\StructType\GuaranteeType $guarantee = null, $notes = null, $creditCardSurcharge = null, $roomBlockCode = null, \room\StructType\TicketItemType $ticketItem = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setReservationType($reservationType)
            ->setBookingDate($bookingDate)
            ->setCRSConfirmationNumber($cRSConfirmationNumber)
            ->setCRSConfirmationNumber2($cRSConfirmationNumber2)
            ->setPromotionalCode($promotionalCode)
            ->setUseKeyCodes($useKeyCodes)
            ->setRoomStays($roomStays)
            ->setProfiles($profiles)
            ->setBookerRPH($bookerRPH)
            ->setPaymentStatus($paymentStatus)
            ->setGuarantee($guarantee)
            ->setNotes($notes)
            ->setCreditCardSurcharge($creditCardSurcharge)
            ->setRoomBlockCode($roomBlockCode)
            ->setTicketItem($ticketItem);
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \room\StructType\HotelRefType $hotelRef
     * @return \room\StructType\ReservationType
     */
    public function setHotelRef(\room\StructType\HotelRefType $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get ReservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->ReservationType;
    }
    /**
     * Set ReservationType value
     * @param string $reservationType
     * @return \room\StructType\ReservationType
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationType) && !is_string($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationType, true), gettype($reservationType)), __LINE__);
        }
        $this->ReservationType = $reservationType;
        return $this;
    }
    /**
     * Get BookingDate value
     * @return string|null
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param string $bookingDate
     * @return \room\StructType\ReservationType
     */
    public function setBookingDate($bookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDate) && !is_string($bookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDate, true), gettype($bookingDate)), __LINE__);
        }
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get CRSConfirmationNumber value
     * @return string|null
     */
    public function getCRSConfirmationNumber()
    {
        return $this->CRSConfirmationNumber;
    }
    /**
     * Set CRSConfirmationNumber value
     * @param string $cRSConfirmationNumber
     * @return \room\StructType\ReservationType
     */
    public function setCRSConfirmationNumber($cRSConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cRSConfirmationNumber) && !is_string($cRSConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSConfirmationNumber, true), gettype($cRSConfirmationNumber)), __LINE__);
        }
        $this->CRSConfirmationNumber = $cRSConfirmationNumber;
        return $this;
    }
    /**
     * Get CRSConfirmationNumber2 value
     * @return string|null
     */
    public function getCRSConfirmationNumber2()
    {
        return $this->CRSConfirmationNumber2;
    }
    /**
     * Set CRSConfirmationNumber2 value
     * @param string $cRSConfirmationNumber2
     * @return \room\StructType\ReservationType
     */
    public function setCRSConfirmationNumber2($cRSConfirmationNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($cRSConfirmationNumber2) && !is_string($cRSConfirmationNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSConfirmationNumber2, true), gettype($cRSConfirmationNumber2)), __LINE__);
        }
        $this->CRSConfirmationNumber2 = $cRSConfirmationNumber2;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * @return string|null
     */
    public function getPromotionalCode()
    {
        return $this->PromotionalCode;
    }
    /**
     * Set PromotionalCode value
     * @param string $promotionalCode
     * @return \room\StructType\ReservationType
     */
    public function setPromotionalCode($promotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalCode) && !is_string($promotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalCode, true), gettype($promotionalCode)), __LINE__);
        }
        $this->PromotionalCode = $promotionalCode;
        return $this;
    }
    /**
     * Get UseKeyCodes value
     * @return bool|null
     */
    public function getUseKeyCodes()
    {
        return $this->UseKeyCodes;
    }
    /**
     * Set UseKeyCodes value
     * @param bool $useKeyCodes
     * @return \room\StructType\ReservationType
     */
    public function setUseKeyCodes($useKeyCodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($useKeyCodes) && !is_bool($useKeyCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useKeyCodes, true), gettype($useKeyCodes)), __LINE__);
        }
        $this->UseKeyCodes = $useKeyCodes;
        return $this;
    }
    /**
     * Get RoomStays value
     * @return \room\StructType\RoomStaysType|null
     */
    public function getRoomStays()
    {
        return $this->RoomStays;
    }
    /**
     * Set RoomStays value
     * @param \room\StructType\RoomStaysType $roomStays
     * @return \room\StructType\ReservationType
     */
    public function setRoomStays(\room\StructType\RoomStaysType $roomStays = null)
    {
        $this->RoomStays = $roomStays;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \room\StructType\ProfilesType|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \room\StructType\ProfilesType $profiles
     * @return \room\StructType\ReservationType
     */
    public function setProfiles(\room\StructType\ProfilesType $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get BookerRPH value
     * @return \room\StructType\BookerRPH|null
     */
    public function getBookerRPH()
    {
        return $this->BookerRPH;
    }
    /**
     * Set BookerRPH value
     * @param \room\StructType\BookerRPH $bookerRPH
     * @return \room\StructType\ReservationType
     */
    public function setBookerRPH(\room\StructType\BookerRPH $bookerRPH = null)
    {
        $this->BookerRPH = $bookerRPH;
        return $this;
    }
    /**
     * Get PaymentStatus value
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @param string $paymentStatus
     * @return \room\StructType\ReservationType
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatus) && !is_string($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatus, true), gettype($paymentStatus)), __LINE__);
        }
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return \room\StructType\GuaranteeType|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @param \room\StructType\GuaranteeType $guarantee
     * @return \room\StructType\ReservationType
     */
    public function setGuarantee(\room\StructType\GuaranteeType $guarantee = null)
    {
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \room\StructType\ReservationType
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CreditCardSurcharge value
     * @return float|null
     */
    public function getCreditCardSurcharge()
    {
        return $this->CreditCardSurcharge;
    }
    /**
     * Set CreditCardSurcharge value
     * @param float $creditCardSurcharge
     * @return \room\StructType\ReservationType
     */
    public function setCreditCardSurcharge($creditCardSurcharge = null)
    {
        // validation for constraint: float
        if (!is_null($creditCardSurcharge) && !(is_float($creditCardSurcharge) || is_numeric($creditCardSurcharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditCardSurcharge, true), gettype($creditCardSurcharge)), __LINE__);
        }
        $this->CreditCardSurcharge = $creditCardSurcharge;
        return $this;
    }
    /**
     * Get RoomBlockCode value
     * @return string|null
     */
    public function getRoomBlockCode()
    {
        return $this->RoomBlockCode;
    }
    /**
     * Set RoomBlockCode value
     * @param string $roomBlockCode
     * @return \room\StructType\ReservationType
     */
    public function setRoomBlockCode($roomBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomBlockCode) && !is_string($roomBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomBlockCode, true), gettype($roomBlockCode)), __LINE__);
        }
        $this->RoomBlockCode = $roomBlockCode;
        return $this;
    }
    /**
     * Get TicketItem value
     * @return \room\StructType\TicketItemType|null
     */
    public function getTicketItem()
    {
        return $this->TicketItem;
    }
    /**
     * Set TicketItem value
     * @param \room\StructType\TicketItemType $ticketItem
     * @return \room\StructType\ReservationType
     */
    public function setTicketItem(\room\StructType\TicketItemType $ticketItem = null)
    {
        $this->TicketItem = $ticketItem;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\ReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
