<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionsType StructType
 * @subpackage Structs
 */
class RegionsType extends AbstractStructBase
{
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\RegionType[]
     */
    public $Region;
    /**
     * Constructor method for RegionsType
     * @uses RegionsType::setRegion()
     * @param \room\StructType\RegionType[] $region
     */
    public function __construct(array $region = array())
    {
        $this
            ->setRegion($region);
    }
    /**
     * Get Region value
     * @return \room\StructType\RegionType[]|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * This method is responsible for validating the values passed to the setRegion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegionForArrayConstraintsFromSetRegion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $regionsTypeRegionItem) {
            // validation for constraint: itemType
            if (!$regionsTypeRegionItem instanceof \room\StructType\RegionType) {
                $invalidValues[] = is_object($regionsTypeRegionItem) ? get_class($regionsTypeRegionItem) : sprintf('%s(%s)', gettype($regionsTypeRegionItem), var_export($regionsTypeRegionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Region property can only contain items of type \room\StructType\RegionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Region value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RegionType[] $region
     * @return \room\StructType\RegionsType
     */
    public function setRegion(array $region = array())
    {
        // validation for constraint: array
        if ('' !== ($regionArrayErrorMessage = self::validateRegionForArrayConstraintsFromSetRegion($region))) {
            throw new \InvalidArgumentException($regionArrayErrorMessage, __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Add item to Region value
     * @throws \InvalidArgumentException
     * @param \room\StructType\RegionType $item
     * @return \room\StructType\RegionsType
     */
    public function addToRegion(\room\StructType\RegionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\RegionType) {
            throw new \InvalidArgumentException(sprintf('The Region property can only contain items of type \room\StructType\RegionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Region[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RegionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
