<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyType StructType
 * @subpackage Structs
 */
class PenaltyType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Applicable
     * @var string
     */
    public $Applicable;
    /**
     * Constructor method for PenaltyType
     * @uses PenaltyType::setCode()
     * @uses PenaltyType::setAmount()
     * @uses PenaltyType::setApplicable()
     * @param string $code
     * @param float $amount
     * @param string $applicable
     */
    public function __construct($code = null, $amount = null, $applicable = null)
    {
        $this
            ->setCode($code)
            ->setAmount($amount)
            ->setApplicable($applicable);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \room\EnumType\PenaltyCodeType::valueIsValid()
     * @uses \room\EnumType\PenaltyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \room\StructType\PenaltyType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\room\EnumType\PenaltyCodeType::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \room\EnumType\PenaltyCodeType', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \room\EnumType\PenaltyCodeType::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \room\StructType\PenaltyType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Applicable value
     * @return string|null
     */
    public function getApplicable()
    {
        return $this->Applicable;
    }
    /**
     * Set Applicable value
     * @param string $applicable
     * @return \room\StructType\PenaltyType
     */
    public function setApplicable($applicable = null)
    {
        // validation for constraint: string
        if (!is_null($applicable) && !is_string($applicable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicable, true), gettype($applicable)), __LINE__);
        }
        $this->Applicable = $applicable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\PenaltyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
