<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeProfileRS StructType
 * @subpackage Structs
 */
class MakeProfileRS extends ResponseType
{
    /**
     * The ResultCode
     * @var string
     */
    public $ResultCode;
    /**
     * The PrfRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrfRef;
    /**
     * Constructor method for MakeProfileRS
     * @uses MakeProfileRS::setResultCode()
     * @uses MakeProfileRS::setPrfRef()
     * @param string $resultCode
     * @param string $prfRef
     */
    public function __construct($resultCode = null, $prfRef = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setPrfRef($prfRef);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \room\StructType\MakeProfileRS
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get PrfRef value
     * @return string|null
     */
    public function getPrfRef()
    {
        return $this->PrfRef;
    }
    /**
     * Set PrfRef value
     * @param string $prfRef
     * @return \room\StructType\MakeProfileRS
     */
    public function setPrfRef($prfRef = null)
    {
        // validation for constraint: string
        if (!is_null($prfRef) && !is_string($prfRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prfRef, true), gettype($prfRef)), __LINE__);
        }
        $this->PrfRef = $prfRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\MakeProfileRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
