<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationFilterType StructType
 * @subpackage Structs
 */
class LocationFilterType extends AbstractStructBase
{
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\Destination
     */
    public $Destination;
    /**
     * The SpecificHotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\HotelRefType
     */
    public $SpecificHotel;
    /**
     * The SearchRadius
     * @var int
     */
    public $SearchRadius;
    /**
     * Constructor method for LocationFilterType
     * @uses LocationFilterType::setDestination()
     * @uses LocationFilterType::setSpecificHotel()
     * @uses LocationFilterType::setSearchRadius()
     * @param \room\StructType\Destination $destination
     * @param \room\StructType\HotelRefType $specificHotel
     * @param int $searchRadius
     */
    public function __construct(\room\StructType\Destination $destination = null, \room\StructType\HotelRefType $specificHotel = null, $searchRadius = null)
    {
        $this
            ->setDestination($destination)
            ->setSpecificHotel($specificHotel)
            ->setSearchRadius($searchRadius);
    }
    /**
     * Get Destination value
     * @return \room\StructType\Destination|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param \room\StructType\Destination $destination
     * @return \room\StructType\LocationFilterType
     */
    public function setDestination(\room\StructType\Destination $destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get SpecificHotel value
     * @return \room\StructType\HotelRefType|null
     */
    public function getSpecificHotel()
    {
        return $this->SpecificHotel;
    }
    /**
     * Set SpecificHotel value
     * @param \room\StructType\HotelRefType $specificHotel
     * @return \room\StructType\LocationFilterType
     */
    public function setSpecificHotel(\room\StructType\HotelRefType $specificHotel = null)
    {
        $this->SpecificHotel = $specificHotel;
        return $this;
    }
    /**
     * Get SearchRadius value
     * @return int|null
     */
    public function getSearchRadius()
    {
        return $this->SearchRadius;
    }
    /**
     * Set SearchRadius value
     * @param int $searchRadius
     * @return \room\StructType\LocationFilterType
     */
    public function setSearchRadius($searchRadius = null)
    {
        // validation for constraint: int
        if (!is_null($searchRadius) && !(is_int($searchRadius) || ctype_digit($searchRadius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchRadius, true), gettype($searchRadius)), __LINE__);
        }
        $this->SearchRadius = $searchRadius;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\LocationFilterType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
