<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelListType StructType
 * @subpackage Structs
 */
class HotelListType extends AbstractStructBase
{
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \room\StructType\HotelRefType[]
     */
    public $HotelRef;
    /**
     * Constructor method for HotelListType
     * @uses HotelListType::setHotelRef()
     * @param \room\StructType\HotelRefType[] $hotelRef
     */
    public function __construct(array $hotelRef = array())
    {
        $this
            ->setHotelRef($hotelRef);
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType[]|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRefForArrayConstraintsFromSetHotelRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelListTypeHotelRefItem) {
            // validation for constraint: itemType
            if (!$hotelListTypeHotelRefItem instanceof \room\StructType\HotelRefType) {
                $invalidValues[] = is_object($hotelListTypeHotelRefItem) ? get_class($hotelListTypeHotelRefItem) : sprintf('%s(%s)', gettype($hotelListTypeHotelRefItem), var_export($hotelListTypeHotelRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRef property can only contain items of type \room\StructType\HotelRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRef value
     * @throws \InvalidArgumentException
     * @param \room\StructType\HotelRefType[] $hotelRef
     * @return \room\StructType\HotelListType
     */
    public function setHotelRef(array $hotelRef = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRefArrayErrorMessage = self::validateHotelRefForArrayConstraintsFromSetHotelRef($hotelRef))) {
            throw new \InvalidArgumentException($hotelRefArrayErrorMessage, __LINE__);
        }
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Add item to HotelRef value
     * @throws \InvalidArgumentException
     * @param \room\StructType\HotelRefType $item
     * @return \room\StructType\HotelListType
     */
    public function addToHotelRef(\room\StructType\HotelRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \room\StructType\HotelRefType) {
            throw new \InvalidArgumentException(sprintf('The HotelRef property can only contain items of type \room\StructType\HotelRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\HotelListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
