<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRegionsRQ StructType
 * @subpackage Structs
 */
class GetRegionsRQ extends AbstractStructBase
{
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\CountryType
     */
    public $Country;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The Lang
     * @var string
     */
    public $Lang;
    /**
     * The Debug
     * @var bool
     */
    public $Debug;
    /**
     * Constructor method for GetRegionsRQ
     * @uses GetRegionsRQ::setCountry()
     * @uses GetRegionsRQ::setTimestamp()
     * @uses GetRegionsRQ::setVersion()
     * @uses GetRegionsRQ::setLang()
     * @uses GetRegionsRQ::setDebug()
     * @param \room\StructType\CountryType $country
     * @param string $timestamp
     * @param float $version
     * @param string $lang
     * @param bool $debug
     */
    public function __construct(\room\StructType\CountryType $country = null, $timestamp = null, $version = null, $lang = null, $debug = null)
    {
        $this
            ->setCountry($country)
            ->setTimestamp($timestamp)
            ->setVersion($version)
            ->setLang($lang)
            ->setDebug($debug);
    }
    /**
     * Get Country value
     * @return \room\StructType\CountryType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \room\StructType\CountryType $country
     * @return \room\StructType\GetRegionsRQ
     */
    public function setCountry(\room\StructType\CountryType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \room\StructType\GetRegionsRQ
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \room\StructType\GetRegionsRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->Lang;
    }
    /**
     * Set Lang value
     * @param string $lang
     * @return \room\StructType\GetRegionsRQ
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->Lang = $lang;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \room\StructType\GetRegionsRQ
     */
    public function setDebug($debug = null)
    {
        // validation for constraint: boolean
        if (!is_null($debug) && !is_bool($debug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debug, true), gettype($debug)), __LINE__);
        }
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetRegionsRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
