<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRatesRQ StructType
 * @subpackage Structs
 */
class GetRatesRQ extends AbstractStructBase
{
    /**
     * The HotelRef
     * @var \room\StructType\HotelRefType
     */
    public $HotelRef;
    /**
     * The RatePlanCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RatePlanCodesType
     */
    public $RatePlanCodes;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The Lang
     * @var string
     */
    public $Lang;
    /**
     * The Debug
     * @var bool
     */
    public $Debug;
    /**
     * Constructor method for GetRatesRQ
     * @uses GetRatesRQ::setHotelRef()
     * @uses GetRatesRQ::setRatePlanCodes()
     * @uses GetRatesRQ::setTimestamp()
     * @uses GetRatesRQ::setVersion()
     * @uses GetRatesRQ::setLang()
     * @uses GetRatesRQ::setDebug()
     * @param \room\StructType\HotelRefType $hotelRef
     * @param \room\StructType\RatePlanCodesType $ratePlanCodes
     * @param string $timestamp
     * @param float $version
     * @param string $lang
     * @param bool $debug
     */
    public function __construct(\room\StructType\HotelRefType $hotelRef = null, \room\StructType\RatePlanCodesType $ratePlanCodes = null, $timestamp = null, $version = null, $lang = null, $debug = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setRatePlanCodes($ratePlanCodes)
            ->setTimestamp($timestamp)
            ->setVersion($version)
            ->setLang($lang)
            ->setDebug($debug);
    }
    /**
     * Get HotelRef value
     * @return \room\StructType\HotelRefType|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \room\StructType\HotelRefType $hotelRef
     * @return \room\StructType\GetRatesRQ
     */
    public function setHotelRef(\room\StructType\HotelRefType $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get RatePlanCodes value
     * @return \room\StructType\RatePlanCodesType|null
     */
    public function getRatePlanCodes()
    {
        return $this->RatePlanCodes;
    }
    /**
     * Set RatePlanCodes value
     * @param \room\StructType\RatePlanCodesType $ratePlanCodes
     * @return \room\StructType\GetRatesRQ
     */
    public function setRatePlanCodes(\room\StructType\RatePlanCodesType $ratePlanCodes = null)
    {
        $this->RatePlanCodes = $ratePlanCodes;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \room\StructType\GetRatesRQ
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \room\StructType\GetRatesRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->Lang;
    }
    /**
     * Set Lang value
     * @param string $lang
     * @return \room\StructType\GetRatesRQ
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->Lang = $lang;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \room\StructType\GetRatesRQ
     */
    public function setDebug($debug = null)
    {
        // validation for constraint: boolean
        if (!is_null($debug) && !is_bool($debug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($debug, true), gettype($debug)), __LINE__);
        }
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetRatesRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
