<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCompanyAccountRS StructType
 * @subpackage Structs
 */
class GetCompanyAccountRS extends ResponseType
{
    /**
     * The CompanyRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CompanyRef;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The HoldStatus
     * @var int
     */
    public $HoldStatus;
    /**
     * The CreditRemaining
     * @var float
     */
    public $CreditRemaining;
    /**
     * Constructor method for GetCompanyAccountRS
     * @uses GetCompanyAccountRS::setCompanyRef()
     * @uses GetCompanyAccountRS::setCompanyName()
     * @uses GetCompanyAccountRS::setHoldStatus()
     * @uses GetCompanyAccountRS::setCreditRemaining()
     * @param string $companyRef
     * @param string $companyName
     * @param int $holdStatus
     * @param float $creditRemaining
     */
    public function __construct($companyRef = null, $companyName = null, $holdStatus = null, $creditRemaining = null)
    {
        $this
            ->setCompanyRef($companyRef)
            ->setCompanyName($companyName)
            ->setHoldStatus($holdStatus)
            ->setCreditRemaining($creditRemaining);
    }
    /**
     * Get CompanyRef value
     * @return string|null
     */
    public function getCompanyRef()
    {
        return $this->CompanyRef;
    }
    /**
     * Set CompanyRef value
     * @param string $companyRef
     * @return \room\StructType\GetCompanyAccountRS
     */
    public function setCompanyRef($companyRef = null)
    {
        // validation for constraint: string
        if (!is_null($companyRef) && !is_string($companyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyRef, true), gettype($companyRef)), __LINE__);
        }
        $this->CompanyRef = $companyRef;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \room\StructType\GetCompanyAccountRS
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get HoldStatus value
     * @return int|null
     */
    public function getHoldStatus()
    {
        return $this->HoldStatus;
    }
    /**
     * Set HoldStatus value
     * @param int $holdStatus
     * @return \room\StructType\GetCompanyAccountRS
     */
    public function setHoldStatus($holdStatus = null)
    {
        // validation for constraint: int
        if (!is_null($holdStatus) && !(is_int($holdStatus) || ctype_digit($holdStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holdStatus, true), gettype($holdStatus)), __LINE__);
        }
        $this->HoldStatus = $holdStatus;
        return $this;
    }
    /**
     * Get CreditRemaining value
     * @return float|null
     */
    public function getCreditRemaining()
    {
        return $this->CreditRemaining;
    }
    /**
     * Set CreditRemaining value
     * @param float $creditRemaining
     * @return \room\StructType\GetCompanyAccountRS
     */
    public function setCreditRemaining($creditRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($creditRemaining) && !(is_float($creditRemaining) || is_numeric($creditRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditRemaining, true), gettype($creditRemaining)), __LINE__);
        }
        $this->CreditRemaining = $creditRemaining;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\GetCompanyAccountRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
