<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorType StructType
 * @subpackage Structs
 */
class ErrorType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Dest
     * @var string
     */
    public $Dest;
    /**
     * Constructor method for ErrorType
     * @uses ErrorType::setCode()
     * @uses ErrorType::setDescription()
     * @uses ErrorType::setDest()
     * @param string $code
     * @param string $description
     * @param string $dest
     */
    public function __construct($code = null, $description = null, $dest = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setDest($dest);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \room\StructType\ErrorType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \room\StructType\ErrorType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Dest value
     * @return string|null
     */
    public function getDest()
    {
        return $this->Dest;
    }
    /**
     * Set Dest value
     * @uses \room\EnumType\ErrorDestType::valueIsValid()
     * @uses \room\EnumType\ErrorDestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dest
     * @return \room\StructType\ErrorType
     */
    public function setDest($dest = null)
    {
        // validation for constraint: enumeration
        if (!\room\EnumType\ErrorDestType::valueIsValid($dest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \room\EnumType\ErrorDestType', is_array($dest) ? implode(', ', $dest) : var_export($dest, true), implode(', ', \room\EnumType\ErrorDestType::getValidValues())), __LINE__);
        }
        $this->Dest = $dest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\ErrorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
