<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DCCType StructType
 * @subpackage Structs
 */
class DCCType extends AbstractStructBase
{
    /**
     * The transactionRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionRef;
    /**
     * The resultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resultCode;
    /**
     * The requestSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $requestSuccessful;
    /**
     * The conversionRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $conversionRate;
    /**
     * The expiryTimestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expiryTimestamp;
    /**
     * The merchantCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $merchantCurrencyCode;
    /**
     * The merchantAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $merchantAmount;
    /**
     * The responseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $responseMessage;
    /**
     * Constructor method for DCCType
     * @uses DCCType::setTransactionRef()
     * @uses DCCType::setResultCode()
     * @uses DCCType::setRequestSuccessful()
     * @uses DCCType::setConversionRate()
     * @uses DCCType::setExpiryTimestamp()
     * @uses DCCType::setMerchantCurrencyCode()
     * @uses DCCType::setMerchantAmount()
     * @uses DCCType::setResponseMessage()
     * @param string $transactionRef
     * @param string $resultCode
     * @param bool $requestSuccessful
     * @param string $conversionRate
     * @param string $expiryTimestamp
     * @param string $merchantCurrencyCode
     * @param string $merchantAmount
     * @param string $responseMessage
     */
    public function __construct($transactionRef = null, $resultCode = null, $requestSuccessful = null, $conversionRate = null, $expiryTimestamp = null, $merchantCurrencyCode = null, $merchantAmount = null, $responseMessage = null)
    {
        $this
            ->setTransactionRef($transactionRef)
            ->setResultCode($resultCode)
            ->setRequestSuccessful($requestSuccessful)
            ->setConversionRate($conversionRate)
            ->setExpiryTimestamp($expiryTimestamp)
            ->setMerchantCurrencyCode($merchantCurrencyCode)
            ->setMerchantAmount($merchantAmount)
            ->setResponseMessage($responseMessage);
    }
    /**
     * Get transactionRef value
     * @return string|null
     */
    public function getTransactionRef()
    {
        return $this->transactionRef;
    }
    /**
     * Set transactionRef value
     * @param string $transactionRef
     * @return \room\StructType\DCCType
     */
    public function setTransactionRef($transactionRef = null)
    {
        // validation for constraint: string
        if (!is_null($transactionRef) && !is_string($transactionRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionRef, true), gettype($transactionRef)), __LINE__);
        }
        $this->transactionRef = $transactionRef;
        return $this;
    }
    /**
     * Get resultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->resultCode;
    }
    /**
     * Set resultCode value
     * @param string $resultCode
     * @return \room\StructType\DCCType
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->resultCode = $resultCode;
        return $this;
    }
    /**
     * Get requestSuccessful value
     * @return bool|null
     */
    public function getRequestSuccessful()
    {
        return $this->requestSuccessful;
    }
    /**
     * Set requestSuccessful value
     * @param bool $requestSuccessful
     * @return \room\StructType\DCCType
     */
    public function setRequestSuccessful($requestSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestSuccessful) && !is_bool($requestSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requestSuccessful, true), gettype($requestSuccessful)), __LINE__);
        }
        $this->requestSuccessful = $requestSuccessful;
        return $this;
    }
    /**
     * Get conversionRate value
     * @return string|null
     */
    public function getConversionRate()
    {
        return $this->conversionRate;
    }
    /**
     * Set conversionRate value
     * @param string $conversionRate
     * @return \room\StructType\DCCType
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: string
        if (!is_null($conversionRate) && !is_string($conversionRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->conversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get expiryTimestamp value
     * @return string|null
     */
    public function getExpiryTimestamp()
    {
        return $this->expiryTimestamp;
    }
    /**
     * Set expiryTimestamp value
     * @param string $expiryTimestamp
     * @return \room\StructType\DCCType
     */
    public function setExpiryTimestamp($expiryTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($expiryTimestamp) && !is_string($expiryTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryTimestamp, true), gettype($expiryTimestamp)), __LINE__);
        }
        $this->expiryTimestamp = $expiryTimestamp;
        return $this;
    }
    /**
     * Get merchantCurrencyCode value
     * @return string|null
     */
    public function getMerchantCurrencyCode()
    {
        return $this->merchantCurrencyCode;
    }
    /**
     * Set merchantCurrencyCode value
     * @param string $merchantCurrencyCode
     * @return \room\StructType\DCCType
     */
    public function setMerchantCurrencyCode($merchantCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($merchantCurrencyCode) && !is_string($merchantCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantCurrencyCode, true), gettype($merchantCurrencyCode)), __LINE__);
        }
        $this->merchantCurrencyCode = $merchantCurrencyCode;
        return $this;
    }
    /**
     * Get merchantAmount value
     * @return string|null
     */
    public function getMerchantAmount()
    {
        return $this->merchantAmount;
    }
    /**
     * Set merchantAmount value
     * @param string $merchantAmount
     * @return \room\StructType\DCCType
     */
    public function setMerchantAmount($merchantAmount = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAmount) && !is_string($merchantAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAmount, true), gettype($merchantAmount)), __LINE__);
        }
        $this->merchantAmount = $merchantAmount;
        return $this;
    }
    /**
     * Get responseMessage value
     * @return string|null
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }
    /**
     * Set responseMessage value
     * @param string $responseMessage
     * @return \room\StructType\DCCType
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        $this->responseMessage = $responseMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\DCCType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
