<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardType StructType
 * @subpackage Structs
 */
class CreditCardType extends AbstractStructBase
{
    /**
     * The CardType
     * @var string
     */
    public $CardType;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CardNumber;
    /**
     * The CardHolder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CardHolder;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $IssueDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $ExpireDate;
    /**
     * The IssueNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssueNumber;
    /**
     * The AuthorisationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AuthorisationCode;
    /**
     * The AuthorisationProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\AuthorisationProviderType
     */
    public $AuthorisationProvider;
    /**
     * The SecurityNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SecurityNumber;
    /**
     * Constructor method for CreditCardType
     * @uses CreditCardType::setCardType()
     * @uses CreditCardType::setCardNumber()
     * @uses CreditCardType::setCardHolder()
     * @uses CreditCardType::setIssueDate()
     * @uses CreditCardType::setExpireDate()
     * @uses CreditCardType::setIssueNumber()
     * @uses CreditCardType::setAuthorisationCode()
     * @uses CreditCardType::setAuthorisationProvider()
     * @uses CreditCardType::setSecurityNumber()
     * @param string $cardType
     * @param string $cardNumber
     * @param string $cardHolder
     * @param anySimpleType $issueDate
     * @param anySimpleType $expireDate
     * @param string $issueNumber
     * @param string $authorisationCode
     * @param \room\StructType\AuthorisationProviderType $authorisationProvider
     * @param string $securityNumber
     */
    public function __construct($cardType = null, $cardNumber = null, $cardHolder = null, anySimpleType $issueDate = null, anySimpleType $expireDate = null, $issueNumber = null, $authorisationCode = null, \room\StructType\AuthorisationProviderType $authorisationProvider = null, $securityNumber = null)
    {
        $this
            ->setCardType($cardType)
            ->setCardNumber($cardNumber)
            ->setCardHolder($cardHolder)
            ->setIssueDate($issueDate)
            ->setExpireDate($expireDate)
            ->setIssueNumber($issueNumber)
            ->setAuthorisationCode($authorisationCode)
            ->setAuthorisationProvider($authorisationProvider)
            ->setSecurityNumber($securityNumber);
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \room\StructType\CreditCardType
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \room\StructType\CreditCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardHolder value
     * @return string|null
     */
    public function getCardHolder()
    {
        return $this->CardHolder;
    }
    /**
     * Set CardHolder value
     * @param string $cardHolder
     * @return \room\StructType\CreditCardType
     */
    public function setCardHolder($cardHolder = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolder) && !is_string($cardHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolder, true), gettype($cardHolder)), __LINE__);
        }
        $this->CardHolder = $cardHolder;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return anySimpleType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param anySimpleType $issueDate
     * @return \room\StructType\CreditCardType
     */
    public function setIssueDate(anySimpleType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return anySimpleType|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param anySimpleType $expireDate
     * @return \room\StructType\CreditCardType
     */
    public function setExpireDate(anySimpleType $expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get IssueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->IssueNumber;
    }
    /**
     * Set IssueNumber value
     * @param string $issueNumber
     * @return \room\StructType\CreditCardType
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueNumber, true), gettype($issueNumber)), __LINE__);
        }
        $this->IssueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get AuthorisationCode value
     * @return string|null
     */
    public function getAuthorisationCode()
    {
        return $this->AuthorisationCode;
    }
    /**
     * Set AuthorisationCode value
     * @param string $authorisationCode
     * @return \room\StructType\CreditCardType
     */
    public function setAuthorisationCode($authorisationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorisationCode) && !is_string($authorisationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorisationCode, true), gettype($authorisationCode)), __LINE__);
        }
        $this->AuthorisationCode = $authorisationCode;
        return $this;
    }
    /**
     * Get AuthorisationProvider value
     * @return \room\StructType\AuthorisationProviderType|null
     */
    public function getAuthorisationProvider()
    {
        return $this->AuthorisationProvider;
    }
    /**
     * Set AuthorisationProvider value
     * @param \room\StructType\AuthorisationProviderType $authorisationProvider
     * @return \room\StructType\CreditCardType
     */
    public function setAuthorisationProvider(\room\StructType\AuthorisationProviderType $authorisationProvider = null)
    {
        $this->AuthorisationProvider = $authorisationProvider;
        return $this;
    }
    /**
     * Get SecurityNumber value
     * @return string|null
     */
    public function getSecurityNumber()
    {
        return $this->SecurityNumber;
    }
    /**
     * Set SecurityNumber value
     * @param string $securityNumber
     * @return \room\StructType\CreditCardType
     */
    public function setSecurityNumber($securityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($securityNumber) && !is_string($securityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityNumber, true), gettype($securityNumber)), __LINE__);
        }
        $this->SecurityNumber = $securityNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\CreditCardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
