<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactDetailsType StructType
 * @subpackage Structs
 */
class ContactDetailsType extends AbstractStructBase
{
    /**
     * The TelephoneNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\TelephoneNumbersType
     */
    public $TelephoneNumbers;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * Constructor method for ContactDetailsType
     * @uses ContactDetailsType::setTelephoneNumbers()
     * @uses ContactDetailsType::setFaxNumber()
     * @uses ContactDetailsType::setEmail()
     * @param \room\StructType\TelephoneNumbersType $telephoneNumbers
     * @param string $faxNumber
     * @param string $email
     */
    public function __construct(\room\StructType\TelephoneNumbersType $telephoneNumbers = null, $faxNumber = null, $email = null)
    {
        $this
            ->setTelephoneNumbers($telephoneNumbers)
            ->setFaxNumber($faxNumber)
            ->setEmail($email);
    }
    /**
     * Get TelephoneNumbers value
     * @return \room\StructType\TelephoneNumbersType|null
     */
    public function getTelephoneNumbers()
    {
        return $this->TelephoneNumbers;
    }
    /**
     * Set TelephoneNumbers value
     * @param \room\StructType\TelephoneNumbersType $telephoneNumbers
     * @return \room\StructType\ContactDetailsType
     */
    public function setTelephoneNumbers(\room\StructType\TelephoneNumbersType $telephoneNumbers = null)
    {
        $this->TelephoneNumbers = $telephoneNumbers;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \room\StructType\ContactDetailsType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \room\StructType\ContactDetailsType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\ContactDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
