<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookerRPH StructType
 * @subpackage Structs
 */
class BookerRPH extends AbstractStructBase
{
    /**
     * The ProfileRPH
     * @var int
     */
    public $ProfileRPH;
    /**
     * Constructor method for BookerRPH
     * @uses BookerRPH::setProfileRPH()
     * @param int $profileRPH
     */
    public function __construct($profileRPH = null)
    {
        $this
            ->setProfileRPH($profileRPH);
    }
    /**
     * Get ProfileRPH value
     * @return int|null
     */
    public function getProfileRPH()
    {
        return $this->ProfileRPH;
    }
    /**
     * Set ProfileRPH value
     * @param int $profileRPH
     * @return \room\StructType\BookerRPH
     */
    public function setProfileRPH($profileRPH = null)
    {
        // validation for constraint: int
        if (!is_null($profileRPH) && !(is_int($profileRPH) || ctype_digit($profileRPH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileRPH, true), gettype($profileRPH)), __LINE__);
        }
        $this->ProfileRPH = $profileRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\BookerRPH
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
