<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityType StructType
 * @subpackage Structs
 */
class AvailabilityType extends AbstractStructBase
{
    /**
     * The RoomBlockCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoomBlockCode;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Count
     * @var int
     */
    public $Count;
    /**
     * The AmountAfterTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The StandardPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $StandardPrice;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\RestrictionsType
     */
    public $Restrictions;
    /**
     * Constructor method for AvailabilityType
     * @uses AvailabilityType::setRoomBlockCode()
     * @uses AvailabilityType::setDate()
     * @uses AvailabilityType::setCount()
     * @uses AvailabilityType::setAmountAfterTax()
     * @uses AvailabilityType::setStandardPrice()
     * @uses AvailabilityType::setCurrencyCode()
     * @uses AvailabilityType::setRestrictions()
     * @param string $roomBlockCode
     * @param string $date
     * @param int $count
     * @param float $amountAfterTax
     * @param float $standardPrice
     * @param string $currencyCode
     * @param \room\StructType\RestrictionsType $restrictions
     */
    public function __construct($roomBlockCode = null, $date = null, $count = null, $amountAfterTax = null, $standardPrice = null, $currencyCode = null, \room\StructType\RestrictionsType $restrictions = null)
    {
        $this
            ->setRoomBlockCode($roomBlockCode)
            ->setDate($date)
            ->setCount($count)
            ->setAmountAfterTax($amountAfterTax)
            ->setStandardPrice($standardPrice)
            ->setCurrencyCode($currencyCode)
            ->setRestrictions($restrictions);
    }
    /**
     * Get RoomBlockCode value
     * @return string|null
     */
    public function getRoomBlockCode()
    {
        return $this->RoomBlockCode;
    }
    /**
     * Set RoomBlockCode value
     * @param string $roomBlockCode
     * @return \room\StructType\AvailabilityType
     */
    public function setRoomBlockCode($roomBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomBlockCode) && !is_string($roomBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomBlockCode, true), gettype($roomBlockCode)), __LINE__);
        }
        $this->RoomBlockCode = $roomBlockCode;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \room\StructType\AvailabilityType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \room\StructType\AvailabilityType
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \room\StructType\AvailabilityType
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountAfterTax) && !(is_float($amountAfterTax) || is_numeric($amountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAfterTax, true), gettype($amountAfterTax)), __LINE__);
        }
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get StandardPrice value
     * @return float|null
     */
    public function getStandardPrice()
    {
        return $this->StandardPrice;
    }
    /**
     * Set StandardPrice value
     * @param float $standardPrice
     * @return \room\StructType\AvailabilityType
     */
    public function setStandardPrice($standardPrice = null)
    {
        // validation for constraint: float
        if (!is_null($standardPrice) && !(is_float($standardPrice) || is_numeric($standardPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standardPrice, true), gettype($standardPrice)), __LINE__);
        }
        $this->StandardPrice = $standardPrice;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \room\StructType\AvailabilityType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Restrictions value
     * @return \room\StructType\RestrictionsType|null
     */
    public function getRestrictions()
    {
        return $this->Restrictions;
    }
    /**
     * Set Restrictions value
     * @param \room\StructType\RestrictionsType $restrictions
     * @return \room\StructType\AvailabilityType
     */
    public function setRestrictions(\room\StructType\RestrictionsType $restrictions = null)
    {
        $this->Restrictions = $restrictions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\AvailabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
