<?php

namespace room\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Sets the Auth SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \room\StructType\Auth $auth
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuth(\room\StructType\Auth $auth, $nameSpace = 'http://guestline.com/RoomLynxAPI', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Auth', $auth, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SendProfilePassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\SendProfilePasswordRQ $sendProfilePasswordRequestMessagePart
     * @return \room\StructType\SendProfilePasswordRS|bool
     */
    public function SendProfilePassword(\room\StructType\SendProfilePasswordRQ $sendProfilePasswordRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->SendProfilePassword($sendProfilePasswordRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \room\StructType\SendProfilePasswordRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
