<?php

namespace room\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Auth SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \room\StructType\Auth $auth
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuth(\room\StructType\Auth $auth, $nameSpace = 'http://guestline.com/RoomLynxAPI', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Auth', $auth, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetCountries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetCountriesRQ $getCountriesRequestMessagePart
     * @return \room\StructType\GetCountriesRS|bool
     */
    public function GetCountries(\room\StructType\GetCountriesRQ $getCountriesRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCountries($getCountriesRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHotels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetHotelsRQ $getHotelsRequestMessagePart
     * @return \room\StructType\GetHotelsRS|bool
     */
    public function GetHotels(\room\StructType\GetHotelsRQ $getHotelsRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHotels($getHotelsRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailability
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetAvailabilityRQ $getAvailabilityRequestMessagePart
     * @return \room\StructType\GetAvailabilityRS|bool
     */
    public function GetAvailability(\room\StructType\GetAvailabilityRQ $getAvailabilityRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailability($getAvailabilityRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfileV2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetProfileV2RQ $getProfileV2RequestMessagePart
     * @return \room\StructType\GetProfileV2RS|bool
     */
    public function GetProfileV2(\room\StructType\GetProfileV2RQ $getProfileV2RequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProfileV2($getProfileV2RequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReservation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetReservationRQ $getReservationRequestMessagePart
     * @return \room\StructType\GetReservationRS|bool
     */
    public function GetReservation(\room\StructType\GetReservationRQ $getReservationRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReservation($getReservationRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetObmConfig
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetObmConfigRQ $getObmConfigRequestMessagePart
     * @return \room\StructType\GetObmConfigRS|bool
     */
    public function GetObmConfig(\room\StructType\GetObmConfigRQ $getObmConfigRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetObmConfig($getObmConfigRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpsells
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetUpsellsRQ $getUpsellsRequestMessagePart
     * @return \room\StructType\GetUpsellsRS|bool
     */
    public function GetUpsells(\room\StructType\GetUpsellsRQ $getUpsellsRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUpsells($getUpsellsRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHotelDetails
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetHotelDetailsRQ $getHotelDetailsRequestMessagePart
     * @return \room\StructType\GetHotelDetailsRS|bool
     */
    public function GetHotelDetails(\room\StructType\GetHotelDetailsRQ $getHotelDetailsRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHotelDetails($getHotelDetailsRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetRegionsRQ $getRegionsRequestMessagePart
     * @return \room\StructType\GetRegionsRS|bool
     */
    public function GetRegions(\room\StructType\GetRegionsRQ $getRegionsRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRegions($getRegionsRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLosRules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetLosRulesRQ $getLosRulesRequestMessagePart
     * @return \room\StructType\GetLosRulesRS|bool
     */
    public function GetLosRules(\room\StructType\GetLosRulesRQ $getLosRulesRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLosRules($getLosRulesRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRooms
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetRoomsRQ $getRoomsRequestMessagePart
     * @return \room\StructType\GetRoomsRS|bool
     */
    public function GetRooms(\room\StructType\GetRoomsRQ $getRoomsRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRooms($getRoomsRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetRatesRQ $getRatesRequestMessagePart
     * @return \room\StructType\GetRatesRS|bool
     */
    public function GetRates(\room\StructType\GetRatesRQ $getRatesRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRates($getRatesRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetCompanyAccountRQ $getCompanyAccountRequestMessagePart
     * @return \room\StructType\GetCompanyAccountRS|bool
     */
    public function GetCompanyAccount(\room\StructType\GetCompanyAccountRQ $getCompanyAccountRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyAccount($getCompanyAccountRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfile
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Auth
     * - SOAPHeaderNamespaces: http://guestline.com/RoomLynxAPI
     * - SOAPHeaderTypes: \room\StructType\Auth
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \room\StructType\GetProfileRQ $getProfileRequestMessagePart
     * @return \room\StructType\GetProfileRS|bool
     */
    public function GetProfile(\room\StructType\GetProfileRQ $getProfileRequestMessagePart)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProfile($getProfileRequestMessagePart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \room\StructType\GetAvailabilityRS|\room\StructType\GetCompanyAccountRS|\room\StructType\GetCountriesRS|\room\StructType\GetHotelDetailsRS|\room\StructType\GetHotelsRS|\room\StructType\GetLosRulesRS|\room\StructType\GetObmConfigRS|\room\StructType\GetProfileRS|\room\StructType\GetProfileV2RS|\room\StructType\GetRatesRS|\room\StructType\GetRegionsRS|\room\StructType\GetReservationRS|\room\StructType\GetRoomsRS|\room\StructType\GetUpsellsRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
