<?php

namespace room\EnumType;

/**
 * This class stands for RestrictionTypeType EnumType
 * @subpackage Enumerations
 */
class RestrictionTypeType
{
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'MinLos'
     * @return string 'MinLos'
     */
    const VALUE_MIN_LOS = 'MinLos';
    /**
     * Constant for value 'MaxLos'
     * @return string 'MaxLos'
     */
    const VALUE_MAX_LOS = 'MaxLos';
    /**
     * Constant for value 'CTA'
     * @return string 'CTA'
     */
    const VALUE_CTA = 'CTA';
    /**
     * Constant for value 'CTD'
     * @return string 'CTD'
     */
    const VALUE_CTD = 'CTD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_MIN_LOS
     * @uses self::VALUE_MAX_LOS
     * @uses self::VALUE_CTA
     * @uses self::VALUE_CTD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSED,
            self::VALUE_MIN_LOS,
            self::VALUE_MAX_LOS,
            self::VALUE_CTA,
            self::VALUE_CTD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
