<?php

namespace room\EnumType;

/**
 * This class stands for ProfileTypeType EnumType
 * @subpackage Enumerations
 */
class ProfileTypeType
{
    /**
     * Constant for value 'Guest'
     * @return string 'Guest'
     */
    const VALUE_GUEST = 'Guest';
    /**
     * Constant for value 'Agent'
     * @return string 'Agent'
     */
    const VALUE_AGENT = 'Agent';
    /**
     * Constant for value 'Corporate'
     * @return string 'Corporate'
     */
    const VALUE_CORPORATE = 'Corporate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GUEST
     * @uses self::VALUE_AGENT
     * @uses self::VALUE_CORPORATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GUEST,
            self::VALUE_AGENT,
            self::VALUE_CORPORATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
