<?php

namespace room\EnumType;

/**
 * This class stands for PenaltyApplicableType EnumType
 * @subpackage Enumerations
 */
class PenaltyApplicableType
{
    /**
     * Constant for value 'Full Stay'
     * @return string 'Full Stay'
     */
    const VALUE_FULL_STAY = 'Full Stay';
    /**
     * Constant for value 'First Night Stay'
     * @return string 'First Night Stay'
     */
    const VALUE_FIRST_NIGHT_STAY = 'First Night Stay';
    /**
     * Constant for value 'Other fixed fee'
     * @return string 'Other fixed fee'
     */
    const VALUE_OTHER_FIXED_FEE = 'Other fixed fee';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FULL_STAY
     * @uses self::VALUE_FIRST_NIGHT_STAY
     * @uses self::VALUE_OTHER_FIXED_FEE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FULL_STAY,
            self::VALUE_FIRST_NIGHT_STAY,
            self::VALUE_OTHER_FIXED_FEE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
