<?php

namespace room\EnumType;

/**
 * This class stands for GetAvailabilityModeType EnumType
 * @subpackage Enumerations
 */
class GetAvailabilityModeType
{
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'BestPrice'
     * @return string 'BestPrice'
     */
    const VALUE_BEST_PRICE = 'BestPrice';
    /**
     * Constant for value 'Detailed'
     * @return string 'Detailed'
     */
    const VALUE_DETAILED = 'Detailed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_BEST_PRICE
     * @uses self::VALUE_DETAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_BEST_PRICE,
            self::VALUE_DETAILED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
