<?php

namespace room\EnumType;

/**
 * This class stands for ErrorDestType EnumType
 * @subpackage Enumerations
 */
class ErrorDestType
{
    /**
     * Constant for value 'user'
     * @return string 'user'
     */
    const VALUE_USER = 'user';
    /**
     * Constant for value 'debug'
     * @return string 'debug'
     */
    const VALUE_DEBUG = 'debug';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER
     * @uses self::VALUE_DEBUG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER,
            self::VALUE_DEBUG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
