<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeaderType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HeaderType
 * @subpackage Structs
 */
class HeaderType extends AbstractStructBase
{
    /**
     * The messageId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $messageId;
    /**
     * The physicalSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $physicalSource;
    /**
     * The sourceSystem
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sourceSystem;
    /**
     * The targetSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $targetSystem;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * Constructor method for HeaderType
     * @uses HeaderType::setMessageId()
     * @uses HeaderType::setPhysicalSource()
     * @uses HeaderType::setSourceSystem()
     * @uses HeaderType::setTargetSystem()
     * @uses HeaderType::setTimestamp()
     * @param string $messageId
     * @param string $physicalSource
     * @param string $sourceSystem
     * @param string $targetSystem
     * @param string $timestamp
     */
    public function __construct($messageId = null, $physicalSource = null, $sourceSystem = null, $targetSystem = null, $timestamp = null)
    {
        $this
            ->setMessageId($messageId)
            ->setPhysicalSource($physicalSource)
            ->setSourceSystem($sourceSystem)
            ->setTargetSystem($targetSystem)
            ->setTimestamp($timestamp);
    }
    /**
     * Get messageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param string $messageId
     * @return HeaderType
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get physicalSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhysicalSource()
    {
        return isset($this->physicalSource) ? $this->physicalSource : null;
    }
    /**
     * Set physicalSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $physicalSource
     * @return HeaderType
     */
    public function setPhysicalSource($physicalSource = null)
    {
        // validation for constraint: string
        if (!is_null($physicalSource) && !is_string($physicalSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalSource, true), gettype($physicalSource)), __LINE__);
        }
        if (is_null($physicalSource) || (is_array($physicalSource) && empty($physicalSource))) {
            unset($this->physicalSource);
        } else {
            $this->physicalSource = $physicalSource;
        }
        return $this;
    }
    /**
     * Get sourceSystem value
     * @return string|null
     */
    public function getSourceSystem()
    {
        return $this->sourceSystem;
    }
    /**
     * Set sourceSystem value
     * @param string $sourceSystem
     * @return HeaderType
     */
    public function setSourceSystem($sourceSystem = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSystem) && !is_string($sourceSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceSystem, true), gettype($sourceSystem)), __LINE__);
        }
        $this->sourceSystem = $sourceSystem;
        return $this;
    }
    /**
     * Get targetSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetSystem()
    {
        return isset($this->targetSystem) ? $this->targetSystem : null;
    }
    /**
     * Set targetSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetSystem
     * @return HeaderType
     */
    public function setTargetSystem($targetSystem = null)
    {
        // validation for constraint: string
        if (!is_null($targetSystem) && !is_string($targetSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetSystem, true), gettype($targetSystem)), __LINE__);
        }
        if (is_null($targetSystem) || (is_array($targetSystem) && empty($targetSystem))) {
            unset($this->targetSystem);
        } else {
            $this->targetSystem = $targetSystem;
        }
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return HeaderType
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return HeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
