<?php
/**
 * This class stands for ExemptionFromEntryBanState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExemptionFromEntryBanState
 * @subpackage Enumerations
 */
class ExemptionFromEntryBanState
{
    /**
     * Constant for value 'Concept'
     * @return string 'Concept'
     */
    const VALUE_CONCEPT = 'Concept';
    /**
     * Constant for value 'BeingApproved'
     * @return string 'BeingApproved'
     */
    const VALUE_BEING_APPROVED = 'BeingApproved';
    /**
     * Constant for value 'Approved'
     * @return string 'Approved'
     */
    const VALUE_APPROVED = 'Approved';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'NotApproved'
     * @return string 'NotApproved'
     */
    const VALUE_NOT_APPROVED = 'NotApproved';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONCEPT
     * @uses self::VALUE_BEING_APPROVED
     * @uses self::VALUE_APPROVED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_NOT_APPROVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONCEPT,
            self::VALUE_BEING_APPROVED,
            self::VALUE_APPROVED,
            self::VALUE_REJECTED,
            self::VALUE_NOT_APPROVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
