<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExemptionFromEntryBanAttachment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExemptionFromEntryBanAttachment
 * @subpackage Structs
 */
class ExemptionFromEntryBanAttachment extends AbstractStructBase
{
    /**
     * The AttachmentType
     * @var string
     */
    public $AttachmentType;
    /**
     * The Contents
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Contents;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * Constructor method for ExemptionFromEntryBanAttachment
     * @uses ExemptionFromEntryBanAttachment::setAttachmentType()
     * @uses ExemptionFromEntryBanAttachment::setContents()
     * @uses ExemptionFromEntryBanAttachment::setFileName()
     * @param string $attachmentType
     * @param string $contents
     * @param string $fileName
     */
    public function __construct($attachmentType = null, $contents = null, $fileName = null)
    {
        $this
            ->setAttachmentType($attachmentType)
            ->setContents($contents)
            ->setFileName($fileName);
    }
    /**
     * Get AttachmentType value
     * @return string|null
     */
    public function getAttachmentType()
    {
        return $this->AttachmentType;
    }
    /**
     * Set AttachmentType value
     * @uses ExemptionFromEntryBanAttachmentType::valueIsValid()
     * @uses ExemptionFromEntryBanAttachmentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attachmentType
     * @return ExemptionFromEntryBanAttachment
     */
    public function setAttachmentType($attachmentType = null)
    {
        // validation for constraint: enumeration
        if (!ExemptionFromEntryBanAttachmentType::valueIsValid($attachmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class ExemptionFromEntryBanAttachmentType', is_array($attachmentType) ? implode(', ', $attachmentType) : var_export($attachmentType, true), implode(', ', ExemptionFromEntryBanAttachmentType::getValidValues())), __LINE__);
        }
        $this->AttachmentType = $attachmentType;
        return $this;
    }
    /**
     * Get Contents value
     * @return string|null
     */
    public function getContents()
    {
        return $this->Contents;
    }
    /**
     * Set Contents value
     * @param string $contents
     * @return ExemptionFromEntryBanAttachment
     */
    public function setContents($contents = null)
    {
        // validation for constraint: string
        if (!is_null($contents) && !is_string($contents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contents, true), gettype($contents)), __LINE__);
        }
        $this->Contents = $contents;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return ExemptionFromEntryBanAttachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ExemptionFromEntryBanAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
