<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCRFaultInfoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LCRFaultInfoType
 * @subpackage Structs
 */
class LCRFaultInfoType extends AbstractStructBase
{
    /**
     * The cause
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfLCRFaultInfoType
     */
    public $cause;
    /**
     * The errorNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorNumber;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * Constructor method for LCRFaultInfoType
     * @uses LCRFaultInfoType::setCause()
     * @uses LCRFaultInfoType::setErrorNumber()
     * @uses LCRFaultInfoType::setMessage()
     * @param ArrayOfLCRFaultInfoType $cause
     * @param string $errorNumber
     * @param string $message
     */
    public function __construct(ArrayOfLCRFaultInfoType $cause = null, $errorNumber = null, $message = null)
    {
        $this
            ->setCause($cause)
            ->setErrorNumber($errorNumber)
            ->setMessage($message);
    }
    /**
     * Get cause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfLCRFaultInfoType|null
     */
    public function getCause()
    {
        return isset($this->cause) ? $this->cause : null;
    }
    /**
     * Set cause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfLCRFaultInfoType $cause
     * @return LCRFaultInfoType
     */
    public function setCause(ArrayOfLCRFaultInfoType $cause = null)
    {
        if (is_null($cause) || (is_array($cause) && empty($cause))) {
            unset($this->cause);
        } else {
            $this->cause = $cause;
        }
        return $this;
    }
    /**
     * Get errorNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorNumber()
    {
        return isset($this->errorNumber) ? $this->errorNumber : null;
    }
    /**
     * Set errorNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorNumber
     * @return LCRFaultInfoType
     */
    public function setErrorNumber($errorNumber = null)
    {
        // validation for constraint: string
        if (!is_null($errorNumber) && !is_string($errorNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorNumber, true), gettype($errorNumber)), __LINE__);
        }
        if (is_null($errorNumber) || (is_array($errorNumber) && empty($errorNumber))) {
            unset($this->errorNumber);
        } else {
            $this->errorNumber = $errorNumber;
        }
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return LCRFaultInfoType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LCRFaultInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
