<?php
/**
 * This class stands for ExemptionFromEntryBanLocalizationType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExemptionFromEntryBanLocalizationType
 * @subpackage Enumerations
 */
class ExemptionFromEntryBanLocalizationType
{
    /**
     * Constant for value 'RoadToBuilding'
     * @return string 'RoadToBuilding'
     */
    const VALUE_ROAD_TO_BUILDING = 'RoadToBuilding';
    /**
     * Constant for value 'PassageAlongRoad'
     * @return string 'PassageAlongRoad'
     */
    const VALUE_PASSAGE_ALONG_ROAD = 'PassageAlongRoad';
    /**
     * Constant for value 'PassageAndStandingOnRoad'
     * @return string 'PassageAndStandingOnRoad'
     */
    const VALUE_PASSAGE_AND_STANDING_ON_ROAD = 'PassageAndStandingOnRoad';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ROAD_TO_BUILDING
     * @uses self::VALUE_PASSAGE_ALONG_ROAD
     * @uses self::VALUE_PASSAGE_AND_STANDING_ON_ROAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ROAD_TO_BUILDING,
            self::VALUE_PASSAGE_ALONG_ROAD,
            self::VALUE_PASSAGE_AND_STANDING_ON_ROAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
