<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delivery StructType
 * @subpackage Structs
 */
class Delivery extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $id;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $status;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The mailingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $mailingId;
    /**
     * The deliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $deliveryDate;
    /**
     * The firstOpenDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $firstOpenDate;
    /**
     * The lastOpenDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $lastOpenDate;
    /**
     * The firstClickDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $firstClickDate;
    /**
     * The lastClickDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $lastClickDate;
    /**
     * The opens
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOpen
     */
    public $opens;
    /**
     * The clicks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfClick
     */
    public $clicks;
    /**
     * The bounce
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bounce
     */
    public $bounce;
    /**
     * The complaint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Complaint
     */
    public $complaint;
    /**
     * Constructor method for Delivery
     * @uses Delivery::setId()
     * @uses Delivery::setStatus()
     * @uses Delivery::setCustomer()
     * @uses Delivery::setMailingId()
     * @uses Delivery::setDeliveryDate()
     * @uses Delivery::setFirstOpenDate()
     * @uses Delivery::setLastOpenDate()
     * @uses Delivery::setFirstClickDate()
     * @uses Delivery::setLastClickDate()
     * @uses Delivery::setOpens()
     * @uses Delivery::setClicks()
     * @uses Delivery::setBounce()
     * @uses Delivery::setComplaint()
     * @param \StructType\_string $id
     * @param \StructType\_string $status
     * @param \StructType\Customer $customer
     * @param \StructType\Long $mailingId
     * @param \StructType\_string $deliveryDate
     * @param \StructType\_string $firstOpenDate
     * @param \StructType\_string $lastOpenDate
     * @param \StructType\_string $firstClickDate
     * @param \StructType\_string $lastClickDate
     * @param \ArrayType\ArrayOfOpen $opens
     * @param \ArrayType\ArrayOfClick $clicks
     * @param \StructType\Bounce $bounce
     * @param \StructType\Complaint $complaint
     */
    public function __construct(\StructType\_string $id = null, \StructType\_string $status = null, \StructType\Customer $customer = null, \StructType\Long $mailingId = null, \StructType\_string $deliveryDate = null, \StructType\_string $firstOpenDate = null, \StructType\_string $lastOpenDate = null, \StructType\_string $firstClickDate = null, \StructType\_string $lastClickDate = null, \ArrayType\ArrayOfOpen $opens = null, \ArrayType\ArrayOfClick $clicks = null, \StructType\Bounce $bounce = null, \StructType\Complaint $complaint = null)
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setCustomer($customer)
            ->setMailingId($mailingId)
            ->setDeliveryDate($deliveryDate)
            ->setFirstOpenDate($firstOpenDate)
            ->setLastOpenDate($lastOpenDate)
            ->setFirstClickDate($firstClickDate)
            ->setLastClickDate($lastClickDate)
            ->setOpens($opens)
            ->setClicks($clicks)
            ->setBounce($bounce)
            ->setComplaint($complaint);
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $id
     * @return \StructType\Delivery
     */
    public function setId(\StructType\_string $id = null)
    {
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $status
     * @return \StructType\Delivery
     */
    public function setStatus(\StructType\_string $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return isset($this->customer) ? $this->customer : null;
    }
    /**
     * Set customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Customer $customer
     * @return \StructType\Delivery
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->customer);
        } else {
            $this->customer = $customer;
        }
        return $this;
    }
    /**
     * Get mailingId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getMailingId()
    {
        return isset($this->mailingId) ? $this->mailingId : null;
    }
    /**
     * Set mailingId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $mailingId
     * @return \StructType\Delivery
     */
    public function setMailingId(\StructType\Long $mailingId = null)
    {
        if (is_null($mailingId) || (is_array($mailingId) && empty($mailingId))) {
            unset($this->mailingId);
        } else {
            $this->mailingId = $mailingId;
        }
        return $this;
    }
    /**
     * Get deliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->deliveryDate) ? $this->deliveryDate : null;
    }
    /**
     * Set deliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $deliveryDate
     * @return \StructType\Delivery
     */
    public function setDeliveryDate(\StructType\_string $deliveryDate = null)
    {
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->deliveryDate);
        } else {
            $this->deliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get firstOpenDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getFirstOpenDate()
    {
        return isset($this->firstOpenDate) ? $this->firstOpenDate : null;
    }
    /**
     * Set firstOpenDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $firstOpenDate
     * @return \StructType\Delivery
     */
    public function setFirstOpenDate(\StructType\_string $firstOpenDate = null)
    {
        if (is_null($firstOpenDate) || (is_array($firstOpenDate) && empty($firstOpenDate))) {
            unset($this->firstOpenDate);
        } else {
            $this->firstOpenDate = $firstOpenDate;
        }
        return $this;
    }
    /**
     * Get lastOpenDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getLastOpenDate()
    {
        return isset($this->lastOpenDate) ? $this->lastOpenDate : null;
    }
    /**
     * Set lastOpenDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $lastOpenDate
     * @return \StructType\Delivery
     */
    public function setLastOpenDate(\StructType\_string $lastOpenDate = null)
    {
        if (is_null($lastOpenDate) || (is_array($lastOpenDate) && empty($lastOpenDate))) {
            unset($this->lastOpenDate);
        } else {
            $this->lastOpenDate = $lastOpenDate;
        }
        return $this;
    }
    /**
     * Get firstClickDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getFirstClickDate()
    {
        return isset($this->firstClickDate) ? $this->firstClickDate : null;
    }
    /**
     * Set firstClickDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $firstClickDate
     * @return \StructType\Delivery
     */
    public function setFirstClickDate(\StructType\_string $firstClickDate = null)
    {
        if (is_null($firstClickDate) || (is_array($firstClickDate) && empty($firstClickDate))) {
            unset($this->firstClickDate);
        } else {
            $this->firstClickDate = $firstClickDate;
        }
        return $this;
    }
    /**
     * Get lastClickDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getLastClickDate()
    {
        return isset($this->lastClickDate) ? $this->lastClickDate : null;
    }
    /**
     * Set lastClickDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $lastClickDate
     * @return \StructType\Delivery
     */
    public function setLastClickDate(\StructType\_string $lastClickDate = null)
    {
        if (is_null($lastClickDate) || (is_array($lastClickDate) && empty($lastClickDate))) {
            unset($this->lastClickDate);
        } else {
            $this->lastClickDate = $lastClickDate;
        }
        return $this;
    }
    /**
     * Get opens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOpen|null
     */
    public function getOpens()
    {
        return isset($this->opens) ? $this->opens : null;
    }
    /**
     * Set opens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOpen $opens
     * @return \StructType\Delivery
     */
    public function setOpens(\ArrayType\ArrayOfOpen $opens = null)
    {
        if (is_null($opens) || (is_array($opens) && empty($opens))) {
            unset($this->opens);
        } else {
            $this->opens = $opens;
        }
        return $this;
    }
    /**
     * Get clicks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfClick|null
     */
    public function getClicks()
    {
        return isset($this->clicks) ? $this->clicks : null;
    }
    /**
     * Set clicks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfClick $clicks
     * @return \StructType\Delivery
     */
    public function setClicks(\ArrayType\ArrayOfClick $clicks = null)
    {
        if (is_null($clicks) || (is_array($clicks) && empty($clicks))) {
            unset($this->clicks);
        } else {
            $this->clicks = $clicks;
        }
        return $this;
    }
    /**
     * Get bounce value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bounce|null
     */
    public function getBounce()
    {
        return isset($this->bounce) ? $this->bounce : null;
    }
    /**
     * Set bounce value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Bounce $bounce
     * @return \StructType\Delivery
     */
    public function setBounce(\StructType\Bounce $bounce = null)
    {
        if (is_null($bounce) || (is_array($bounce) && empty($bounce))) {
            unset($this->bounce);
        } else {
            $this->bounce = $bounce;
        }
        return $this;
    }
    /**
     * Get complaint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Complaint|null
     */
    public function getComplaint()
    {
        return isset($this->complaint) ? $this->complaint : null;
    }
    /**
     * Set complaint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Complaint $complaint
     * @return \StructType\Delivery
     */
    public function setComplaint(\StructType\Complaint $complaint = null)
    {
        if (is_null($complaint) || (is_array($complaint) && empty($complaint))) {
            unset($this->complaint);
        } else {
            $this->complaint = $complaint;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
