<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Smsupsert ServiceType
 * @subpackage Services
 */
class Smsupsert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sms_upsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_upsert $parameters
     * @return \StructType\Sms_upsertResponse|bool
     */
    public function sms_upsert(\StructType\Sms_upsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_upsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Sms_upsertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
