<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Magentoget ServiceType
 * @subpackage Services
 */
class Magentoget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named magento_getCampaigns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Magento_getCampaigns $parameters
     * @return \StructType\Magento_getCampaignsResponse|bool
     */
    public function magento_getCampaigns(\StructType\Magento_getCampaigns $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magento_getCampaigns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magento_getAvailableCustomerFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Magento_getAvailableCustomerFields $parameters
     * @return \StructType\Magento_getAvailableCustomerFieldsResponse|bool
     */
    public function magento_getAvailableCustomerFields(\StructType\Magento_getAvailableCustomerFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magento_getAvailableCustomerFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Magento_getAvailableCustomerFieldsResponse|\StructType\Magento_getCampaignsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
