<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Magento ServiceType
 * @subpackage Services
 */
class Magento extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named magentoShipment_insert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoShipment_insert $parameters
     * @return \StructType\MagentoShipment_insertResponse|bool
     */
    public function magentoShipment_insert(\StructType\MagentoShipment_insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoShipment_insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoShipment_create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoShipment_create $parameters
     * @return \StructType\MagentoShipment_createResponse|bool
     */
    public function magentoShipment_create(\StructType\MagentoShipment_create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoShipment_create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoProduct_upsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoProduct_upsert $parameters
     * @return \StructType\MagentoProduct_upsertResponse|bool
     */
    public function magentoProduct_upsert(\StructType\MagentoProduct_upsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoProduct_upsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoProduct_create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoProduct_create $parameters
     * @return \StructType\MagentoProduct_createResponse|bool
     */
    public function magentoProduct_create(\StructType\MagentoProduct_create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoProduct_create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoAbandonedOrder_create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoAbandonedOrder_create $parameters
     * @return \StructType\MagentoAbandonedOrder_createResponse|bool
     */
    public function magentoAbandonedOrder_create(\StructType\MagentoAbandonedOrder_create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoAbandonedOrder_create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoAbandonedOrder_insert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoAbandonedOrder_insert $parameters
     * @return \StructType\MagentoAbandonedOrder_insertResponse|bool
     */
    public function magentoAbandonedOrder_insert(\StructType\MagentoAbandonedOrder_insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoAbandonedOrder_insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoCreditMemo_insert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoCreditMemo_insert $parameters
     * @return \StructType\MagentoCreditMemo_insertResponse|bool
     */
    public function magentoCreditMemo_insert(\StructType\MagentoCreditMemo_insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoCreditMemo_insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoCategory_create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoCategory_create $parameters
     * @return \StructType\MagentoCategory_createResponse|bool
     */
    public function magentoCategory_create(\StructType\MagentoCategory_create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoCategory_create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoCategory_upsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoCategory_upsert $parameters
     * @return \StructType\MagentoCategory_upsertResponse|bool
     */
    public function magentoCategory_upsert(\StructType\MagentoCategory_upsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoCategory_upsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoOrder_update
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoOrder_update $parameters
     * @return \StructType\MagentoOrder_updateResponse|bool
     */
    public function magentoOrder_update(\StructType\MagentoOrder_update $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoOrder_update($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoOrder_create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoOrder_create $parameters
     * @return \StructType\MagentoOrder_createResponse|bool
     */
    public function magentoOrder_create(\StructType\MagentoOrder_create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoOrder_create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoOrder_insert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoOrder_insert $parameters
     * @return \StructType\MagentoOrder_insertResponse|bool
     */
    public function magentoOrder_insert(\StructType\MagentoOrder_insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoOrder_insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoOrder_insertBulk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoOrder_insertBulk $parameters
     * @return \StructType\MagentoOrder_insertBulkResponse|bool
     */
    public function magentoOrder_insertBulk(\StructType\MagentoOrder_insertBulk $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoOrder_insertBulk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magentoEmail_insert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MagentoEmail_insert $parameters
     * @return \StructType\MagentoEmail_insertResponse|bool
     */
    public function magentoEmail_insert(\StructType\MagentoEmail_insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magentoEmail_insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MagentoAbandonedOrder_createResponse|\StructType\MagentoAbandonedOrder_insertResponse|\StructType\MagentoCategory_createResponse|\StructType\MagentoCategory_upsertResponse|\StructType\MagentoCreditMemo_insertResponse|\StructType\MagentoEmail_insertResponse|\StructType\MagentoOrder_createResponse|\StructType\MagentoOrder_insertBulkResponse|\StructType\MagentoOrder_insertResponse|\StructType\MagentoOrder_updateResponse|\StructType\MagentoProduct_createResponse|\StructType\MagentoProduct_upsertResponse|\StructType\MagentoShipment_createResponse|\StructType\MagentoShipment_insertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
