<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Groupremove ServiceType
 * @subpackage Services
 */
class Groupremove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named group_removeAllMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_removeAllMembers $parameters
     * @return \StructType\Group_removeAllMembersResponse|bool
     */
    public function group_removeAllMembers(\StructType\Group_removeAllMembers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_removeAllMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named group_removeMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_removeMember $parameters
     * @return \StructType\Group_removeMemberResponse|bool
     */
    public function group_removeMember(\StructType\Group_removeMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_removeMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Group_removeAllMembersResponse|\StructType\Group_removeMemberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
