<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Grouphas ServiceType
 * @subpackage Services
 */
class Grouphas extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named group_hasMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_hasMember $parameters
     * @return \StructType\Group_hasMemberResponse|bool
     */
    public function group_hasMember(\StructType\Group_hasMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_hasMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Group_hasMemberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
