<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Groupget ServiceType
 * @subpackage Services
 */
class Groupget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named group_getById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_getById $parameters
     * @return \StructType\Group_getByIdResponse|bool
     */
    public function group_getById(\StructType\Group_getById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_getById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named group_getMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_getMembers $parameters
     * @return \StructType\Group_getMembersResponse|bool
     */
    public function group_getMembers(\StructType\Group_getMembers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_getMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named group_getParent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_getParent $parameters
     * @return \StructType\Group_getParentResponse|bool
     */
    public function group_getParent(\StructType\Group_getParent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_getParent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named group_getByObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_getByObject $parameters
     * @return \StructType\Group_getByObjectResponse|bool
     */
    public function group_getByObject(\StructType\Group_getByObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_getByObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named group_getAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_getAll $parameters
     * @return \StructType\Group_getAllResponse|bool
     */
    public function group_getAll(\StructType\Group_getAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_getAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named group_getChildren
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Group_getChildren $parameters
     * @return \StructType\Group_getChildrenResponse|bool
     */
    public function group_getChildren(\StructType\Group_getChildren $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->group_getChildren($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Group_getAllResponse|\StructType\Group_getByIdResponse|\StructType\Group_getByObjectResponse|\StructType\Group_getChildrenResponse|\StructType\Group_getMembersResponse|\StructType\Group_getParentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
