<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Click ServiceType
 * @subpackage Services
 */
class Click extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named clickSet_getClick
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ClickSet_getClick $parameters
     * @return \StructType\ClickSet_getClickResponse|bool
     */
    public function clickSet_getClick(\StructType\ClickSet_getClick $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clickSet_getClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named clickSet_getClicks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ClickSet_getClicks $parameters
     * @return \StructType\ClickSet_getClicksResponse|bool
     */
    public function clickSet_getClicks(\StructType\ClickSet_getClicks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clickSet_getClicks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named clickSet_getClickIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ClickSet_getClickIds $parameters
     * @return \StructType\ClickSet_getClickIdsResponse|bool
     */
    public function clickSet_getClickIds(\StructType\ClickSet_getClickIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clickSet_getClickIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ClickSet_getClickIdsResponse|\StructType\ClickSet_getClickResponse|\StructType\ClickSet_getClicksResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
