<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSms ArrayType
 * @subpackage Arrays
 */
class ArrayOfSms extends AbstractStructArrayBase
{
    /**
     * The Sms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sms[]
     */
    public $Sms;
    /**
     * Constructor method for ArrayOfSms
     * @uses ArrayOfSms::setSms()
     * @param \StructType\Sms[] $sms
     */
    public function __construct(array $sms = array())
    {
        $this
            ->setSms($sms);
    }
    /**
     * Get Sms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sms[]|null
     */
    public function getSms()
    {
        return isset($this->Sms) ? $this->Sms : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSmsForArrayConstraintsFromSetSms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSmsSmsItem) {
            // validation for constraint: itemType
            if (!$arrayOfSmsSmsItem instanceof \StructType\Sms) {
                $invalidValues[] = is_object($arrayOfSmsSmsItem) ? get_class($arrayOfSmsSmsItem) : sprintf('%s(%s)', gettype($arrayOfSmsSmsItem), var_export($arrayOfSmsSmsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sms property can only contain items of type \StructType\Sms, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sms[] $sms
     * @return \ArrayType\ArrayOfSms
     */
    public function setSms(array $sms = array())
    {
        // validation for constraint: array
        if ('' !== ($smsArrayErrorMessage = self::validateSmsForArrayConstraintsFromSetSms($sms))) {
            throw new \InvalidArgumentException($smsArrayErrorMessage, __LINE__);
        }
        if (is_null($sms) || (is_array($sms) && empty($sms))) {
            unset($this->Sms);
        } else {
            $this->Sms = $sms;
        }
        return $this;
    }
    /**
     * Add item to Sms value
     * @throws \InvalidArgumentException
     * @param \StructType\Sms $item
     * @return \ArrayType\ArrayOfSms
     */
    public function addToSms(\StructType\Sms $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sms) {
            throw new \InvalidArgumentException(sprintf('The Sms property can only contain items of type \StructType\Sms, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sms[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Sms|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Sms|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Sms|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Sms|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Sms|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Sms
     */
    public function getAttributeName()
    {
        return 'Sms';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
