<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInt ArrayType
 * @subpackage Arrays
 */
class ArrayOfInt extends AbstractStructArrayBase
{
    /**
     * The integer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Integer[]
     */
    public $integer;
    /**
     * Constructor method for ArrayOfInt
     * @uses ArrayOfInt::setInteger()
     * @param \StructType\Integer[] $integer
     */
    public function __construct(array $integer = array())
    {
        $this
            ->setInteger($integer);
    }
    /**
     * Get integer value
     * @return \StructType\Integer[]|null
     */
    public function getInteger()
    {
        return $this->integer;
    }
    /**
     * This method is responsible for validating the values passed to the setInteger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInteger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIntegerForArrayConstraintsFromSetInteger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIntIntegerItem) {
            // validation for constraint: itemType
            if (!$arrayOfIntIntegerItem instanceof \StructType\Integer) {
                $invalidValues[] = is_object($arrayOfIntIntegerItem) ? get_class($arrayOfIntIntegerItem) : sprintf('%s(%s)', gettype($arrayOfIntIntegerItem), var_export($arrayOfIntIntegerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The integer property can only contain items of type \StructType\Integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set integer value
     * @throws \InvalidArgumentException
     * @param \StructType\Integer[] $integer
     * @return \ArrayType\ArrayOfInt
     */
    public function setInteger(array $integer = array())
    {
        // validation for constraint: array
        if ('' !== ($integerArrayErrorMessage = self::validateIntegerForArrayConstraintsFromSetInteger($integer))) {
            throw new \InvalidArgumentException($integerArrayErrorMessage, __LINE__);
        }
        $this->integer = $integer;
        return $this;
    }
    /**
     * Add item to integer value
     * @throws \InvalidArgumentException
     * @param \StructType\Integer $item
     * @return \ArrayType\ArrayOfInt
     */
    public function addToInteger(\StructType\Integer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Integer) {
            throw new \InvalidArgumentException(sprintf('The integer property can only contain items of type \StructType\Integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->integer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Integer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Integer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Integer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Integer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Integer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string integer
     */
    public function getAttributeName()
    {
        return 'integer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
