<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfComplaint ArrayType
 * @subpackage Arrays
 */
class ArrayOfComplaint extends AbstractStructArrayBase
{
    /**
     * The Complaint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Complaint[]
     */
    public $Complaint;
    /**
     * Constructor method for ArrayOfComplaint
     * @uses ArrayOfComplaint::setComplaint()
     * @param \StructType\Complaint[] $complaint
     */
    public function __construct(array $complaint = array())
    {
        $this
            ->setComplaint($complaint);
    }
    /**
     * Get Complaint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Complaint[]|null
     */
    public function getComplaint()
    {
        return isset($this->Complaint) ? $this->Complaint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setComplaint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComplaint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComplaintForArrayConstraintsFromSetComplaint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfComplaintComplaintItem) {
            // validation for constraint: itemType
            if (!$arrayOfComplaintComplaintItem instanceof \StructType\Complaint) {
                $invalidValues[] = is_object($arrayOfComplaintComplaintItem) ? get_class($arrayOfComplaintComplaintItem) : sprintf('%s(%s)', gettype($arrayOfComplaintComplaintItem), var_export($arrayOfComplaintComplaintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Complaint property can only contain items of type \StructType\Complaint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Complaint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Complaint[] $complaint
     * @return \ArrayType\ArrayOfComplaint
     */
    public function setComplaint(array $complaint = array())
    {
        // validation for constraint: array
        if ('' !== ($complaintArrayErrorMessage = self::validateComplaintForArrayConstraintsFromSetComplaint($complaint))) {
            throw new \InvalidArgumentException($complaintArrayErrorMessage, __LINE__);
        }
        if (is_null($complaint) || (is_array($complaint) && empty($complaint))) {
            unset($this->Complaint);
        } else {
            $this->Complaint = $complaint;
        }
        return $this;
    }
    /**
     * Add item to Complaint value
     * @throws \InvalidArgumentException
     * @param \StructType\Complaint $item
     * @return \ArrayType\ArrayOfComplaint
     */
    public function addToComplaint(\StructType\Complaint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Complaint) {
            throw new \InvalidArgumentException(sprintf('The Complaint property can only contain items of type \StructType\Complaint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Complaint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Complaint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Complaint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Complaint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Complaint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Complaint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Complaint
     */
    public function getAttributeName()
    {
        return 'Complaint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfComplaint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
