<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://secure.myclang.com/app/api/soap/public/index.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://secure.myclang.com/app/api/soap/public/index.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Emailinsert ServiceType
 */
$emailinsert = new \ServiceType\Emailinsert($options);
/**
 * Sample call for email_insert operation/method
 */
if ($emailinsert->email_insert(new \StructType\Email_insert()) !== false) {
    print_r($emailinsert->getResult());
} else {
    print_r($emailinsert->getLastError());
}
/**
 * Samples for Emailupdate ServiceType
 */
$emailupdate = new \ServiceType\Emailupdate($options);
/**
 * Sample call for email_update operation/method
 */
if ($emailupdate->email_update(new \StructType\Email_update()) !== false) {
    print_r($emailupdate->getResult());
} else {
    print_r($emailupdate->getLastError());
}
/**
 * Samples for Emailupsert ServiceType
 */
$emailupsert = new \ServiceType\Emailupsert($options);
/**
 * Sample call for email_upsert operation/method
 */
if ($emailupsert->email_upsert(new \StructType\Email_upsert()) !== false) {
    print_r($emailupsert->getResult());
} else {
    print_r($emailupsert->getLastError());
}
/**
 * Samples for Emailget ServiceType
 */
$emailget = new \ServiceType\Emailget($options);
/**
 * Sample call for email_getById operation/method
 */
if ($emailget->email_getById(new \StructType\Email_getById()) !== false) {
    print_r($emailget->getResult());
} else {
    print_r($emailget->getLastError());
}
/**
 * Sample call for email_getByObject operation/method
 */
if ($emailget->email_getByObject(new \StructType\Email_getByObject()) !== false) {
    print_r($emailget->getResult());
} else {
    print_r($emailget->getLastError());
}
/**
 * Sample call for email_getAll operation/method
 */
if ($emailget->email_getAll(new \StructType\Email_getAll()) !== false) {
    print_r($emailget->getResult());
} else {
    print_r($emailget->getLastError());
}
/**
 * Samples for Emaillist ServiceType
 */
$emaillist = new \ServiceType\Emaillist($options);
/**
 * Sample call for email_listOptions operation/method
 */
if ($emaillist->email_listOptions(new \StructType\Email_listOptions()) !== false) {
    print_r($emaillist->getResult());
} else {
    print_r($emaillist->getLastError());
}
/**
 * Samples for Emailsend ServiceType
 */
$emailsend = new \ServiceType\Emailsend($options);
/**
 * Sample call for email_sendToGroup operation/method
 */
if ($emailsend->email_sendToGroup(new \StructType\Email_sendToGroup()) !== false) {
    print_r($emailsend->getResult());
} else {
    print_r($emailsend->getLastError());
}
/**
 * Sample call for email_sendToProfile operation/method
 */
if ($emailsend->email_sendToProfile(new \StructType\Email_sendToProfile()) !== false) {
    print_r($emailsend->getResult());
} else {
    print_r($emailsend->getLastError());
}
/**
 * Sample call for email_sendToCustomer operation/method
 */
if ($emailsend->email_sendToCustomer(new \StructType\Email_sendToCustomer()) !== false) {
    print_r($emailsend->getResult());
} else {
    print_r($emailsend->getLastError());
}
/**
 * Sample call for email_sendToCustomers operation/method
 */
if ($emailsend->email_sendToCustomers(new \StructType\Email_sendToCustomers()) !== false) {
    print_r($emailsend->getResult());
} else {
    print_r($emailsend->getLastError());
}
/**
 * Samples for Emaildelete ServiceType
 */
$emaildelete = new \ServiceType\Emaildelete($options);
/**
 * Sample call for email_delete operation/method
 */
if ($emaildelete->email_delete(new \StructType\Email_delete()) !== false) {
    print_r($emaildelete->getResult());
} else {
    print_r($emaildelete->getLastError());
}
/**
 * Samples for Emailhas ServiceType
 */
$emailhas = new \ServiceType\Emailhas($options);
/**
 * Sample call for email_hasChanged operation/method
 */
if ($emailhas->email_hasChanged(new \StructType\Email_hasChanged()) !== false) {
    print_r($emailhas->getResult());
} else {
    print_r($emailhas->getLastError());
}
/**
 * Samples for Emailcreate ServiceType
 */
$emailcreate = new \ServiceType\Emailcreate($options);
/**
 * Sample call for email_create operation/method
 */
if ($emailcreate->email_create(new \StructType\Email_create()) !== false) {
    print_r($emailcreate->getResult());
} else {
    print_r($emailcreate->getLastError());
}
/**
 * Samples for Openget ServiceType
 */
$openget = new \ServiceType\Openget($options);
/**
 * Sample call for open_getById operation/method
 */
if ($openget->open_getById(new \StructType\Open_getById()) !== false) {
    print_r($openget->getResult());
} else {
    print_r($openget->getLastError());
}
/**
 * Samples for Filemanagermake ServiceType
 */
$filemanagermake = new \ServiceType\Filemanagermake($options);
/**
 * Sample call for filemanager_makeDir operation/method
 */
if ($filemanagermake->filemanager_makeDir(new \StructType\Filemanager_makeDir()) !== false) {
    print_r($filemanagermake->getResult());
} else {
    print_r($filemanagermake->getLastError());
}
/**
 * Samples for Resourceget ServiceType
 */
$resourceget = new \ServiceType\Resourceget($options);
/**
 * Sample call for resource_getById operation/method
 */
if ($resourceget->resource_getById(new \StructType\Resource_getById()) !== false) {
    print_r($resourceget->getResult());
} else {
    print_r($resourceget->getLastError());
}
/**
 * Samples for Resourcefree ServiceType
 */
$resourcefree = new \ServiceType\Resourcefree($options);
/**
 * Sample call for resource_free operation/method
 */
if ($resourcefree->resource_free(new \StructType\Resource_free()) !== false) {
    print_r($resourcefree->getResult());
} else {
    print_r($resourcefree->getLastError());
}
/**
 * Samples for Magento ServiceType
 */
$magento = new \ServiceType\Magento($options);
/**
 * Sample call for magentoShipment_insert operation/method
 */
if ($magento->magentoShipment_insert(new \StructType\MagentoShipment_insert()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoShipment_create operation/method
 */
if ($magento->magentoShipment_create(new \StructType\MagentoShipment_create()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoProduct_upsert operation/method
 */
if ($magento->magentoProduct_upsert(new \StructType\MagentoProduct_upsert()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoProduct_create operation/method
 */
if ($magento->magentoProduct_create(new \StructType\MagentoProduct_create()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoAbandonedOrder_create operation/method
 */
if ($magento->magentoAbandonedOrder_create(new \StructType\MagentoAbandonedOrder_create()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoAbandonedOrder_insert operation/method
 */
if ($magento->magentoAbandonedOrder_insert(new \StructType\MagentoAbandonedOrder_insert()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoCreditMemo_insert operation/method
 */
if ($magento->magentoCreditMemo_insert(new \StructType\MagentoCreditMemo_insert()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoCategory_create operation/method
 */
if ($magento->magentoCategory_create(new \StructType\MagentoCategory_create()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoCategory_upsert operation/method
 */
if ($magento->magentoCategory_upsert(new \StructType\MagentoCategory_upsert()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoOrder_update operation/method
 */
if ($magento->magentoOrder_update(new \StructType\MagentoOrder_update()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoOrder_create operation/method
 */
if ($magento->magentoOrder_create(new \StructType\MagentoOrder_create()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoOrder_insert operation/method
 */
if ($magento->magentoOrder_insert(new \StructType\MagentoOrder_insert()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoOrder_insertBulk operation/method
 */
if ($magento->magentoOrder_insertBulk(new \StructType\MagentoOrder_insertBulk()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Sample call for magentoEmail_insert operation/method
 */
if ($magento->magentoEmail_insert(new \StructType\MagentoEmail_insert()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Samples for Mailing ServiceType
 */
$mailing = new \ServiceType\Mailing($options);
/**
 * Sample call for mailingLink_getClickSet operation/method
 */
if ($mailing->mailingLink_getClickSet(new \StructType\MailingLink_getClickSet()) !== false) {
    print_r($mailing->getResult());
} else {
    print_r($mailing->getLastError());
}
/**
 * Sample call for mailingSet_getMailing operation/method
 */
if ($mailing->mailingSet_getMailing(new \StructType\MailingSet_getMailing()) !== false) {
    print_r($mailing->getResult());
} else {
    print_r($mailing->getLastError());
}
/**
 * Sample call for mailingSet_getMailings operation/method
 */
if ($mailing->mailingSet_getMailings(new \StructType\MailingSet_getMailings()) !== false) {
    print_r($mailing->getResult());
} else {
    print_r($mailing->getLastError());
}
/**
 * Sample call for mailingSet_getMailingIds operation/method
 */
if ($mailing->mailingSet_getMailingIds(new \StructType\MailingSet_getMailingIds()) !== false) {
    print_r($mailing->getResult());
} else {
    print_r($mailing->getLastError());
}
/**
 * Samples for Smslist ServiceType
 */
$smslist = new \ServiceType\Smslist($options);
/**
 * Sample call for sms_listOptions operation/method
 */
if ($smslist->sms_listOptions(new \StructType\Sms_listOptions()) !== false) {
    print_r($smslist->getResult());
} else {
    print_r($smslist->getLastError());
}
/**
 * Samples for Smscreate ServiceType
 */
$smscreate = new \ServiceType\Smscreate($options);
/**
 * Sample call for sms_create operation/method
 */
if ($smscreate->sms_create(new \StructType\Sms_create()) !== false) {
    print_r($smscreate->getResult());
} else {
    print_r($smscreate->getLastError());
}
/**
 * Samples for Smsdelete ServiceType
 */
$smsdelete = new \ServiceType\Smsdelete($options);
/**
 * Sample call for sms_delete operation/method
 */
if ($smsdelete->sms_delete(new \StructType\Sms_delete()) !== false) {
    print_r($smsdelete->getResult());
} else {
    print_r($smsdelete->getLastError());
}
/**
 * Samples for Smssend ServiceType
 */
$smssend = new \ServiceType\Smssend($options);
/**
 * Sample call for sms_sendToCustomer operation/method
 */
if ($smssend->sms_sendToCustomer(new \StructType\Sms_sendToCustomer()) !== false) {
    print_r($smssend->getResult());
} else {
    print_r($smssend->getLastError());
}
/**
 * Sample call for sms_sendToCustomers operation/method
 */
if ($smssend->sms_sendToCustomers(new \StructType\Sms_sendToCustomers()) !== false) {
    print_r($smssend->getResult());
} else {
    print_r($smssend->getLastError());
}
/**
 * Sample call for sms_sendToProfile operation/method
 */
if ($smssend->sms_sendToProfile(new \StructType\Sms_sendToProfile()) !== false) {
    print_r($smssend->getResult());
} else {
    print_r($smssend->getLastError());
}
/**
 * Sample call for sms_sendToGroup operation/method
 */
if ($smssend->sms_sendToGroup(new \StructType\Sms_sendToGroup()) !== false) {
    print_r($smssend->getResult());
} else {
    print_r($smssend->getLastError());
}
/**
 * Samples for Smsget ServiceType
 */
$smsget = new \ServiceType\Smsget($options);
/**
 * Sample call for sms_getAll operation/method
 */
if ($smsget->sms_getAll(new \StructType\Sms_getAll()) !== false) {
    print_r($smsget->getResult());
} else {
    print_r($smsget->getLastError());
}
/**
 * Sample call for sms_getById operation/method
 */
if ($smsget->sms_getById(new \StructType\Sms_getById()) !== false) {
    print_r($smsget->getResult());
} else {
    print_r($smsget->getLastError());
}
/**
 * Sample call for sms_getByObject operation/method
 */
if ($smsget->sms_getByObject(new \StructType\Sms_getByObject()) !== false) {
    print_r($smsget->getResult());
} else {
    print_r($smsget->getLastError());
}
/**
 * Samples for Smsinsert ServiceType
 */
$smsinsert = new \ServiceType\Smsinsert($options);
/**
 * Sample call for sms_insert operation/method
 */
if ($smsinsert->sms_insert(new \StructType\Sms_insert()) !== false) {
    print_r($smsinsert->getResult());
} else {
    print_r($smsinsert->getLastError());
}
/**
 * Samples for Smshas ServiceType
 */
$smshas = new \ServiceType\Smshas($options);
/**
 * Sample call for sms_hasChanged operation/method
 */
if ($smshas->sms_hasChanged(new \StructType\Sms_hasChanged()) !== false) {
    print_r($smshas->getResult());
} else {
    print_r($smshas->getLastError());
}
/**
 * Samples for Smsupdate ServiceType
 */
$smsupdate = new \ServiceType\Smsupdate($options);
/**
 * Sample call for sms_update operation/method
 */
if ($smsupdate->sms_update(new \StructType\Sms_update()) !== false) {
    print_r($smsupdate->getResult());
} else {
    print_r($smsupdate->getLastError());
}
/**
 * Samples for Smsupsert ServiceType
 */
$smsupsert = new \ServiceType\Smsupsert($options);
/**
 * Sample call for sms_upsert operation/method
 */
if ($smsupsert->sms_upsert(new \StructType\Sms_upsert()) !== false) {
    print_r($smsupsert->getResult());
} else {
    print_r($smsupsert->getLastError());
}
/**
 * Samples for Customer ServiceType
 */
$customer = new \ServiceType\Customer($options);
/**
 * Sample call for customerSet_getCustomer operation/method
 */
if ($customer->customerSet_getCustomer(new \StructType\CustomerSet_getCustomer()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerSet_getCustomers operation/method
 */
if ($customer->customerSet_getCustomers(new \StructType\CustomerSet_getCustomers()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerSet_getCustomerIds operation/method
 */
if ($customer->customerSet_getCustomerIds(new \StructType\CustomerSet_getCustomerIds()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Campaignget ServiceType
 */
$campaignget = new \ServiceType\Campaignget($options);
/**
 * Sample call for campaign_getAllExecutable operation/method
 */
if ($campaignget->campaign_getAllExecutable(new \StructType\Campaign_getAllExecutable()) !== false) {
    print_r($campaignget->getResult());
} else {
    print_r($campaignget->getLastError());
}
/**
 * Sample call for campaign_getMembers operation/method
 */
if ($campaignget->campaign_getMembers(new \StructType\Campaign_getMembers()) !== false) {
    print_r($campaignget->getResult());
} else {
    print_r($campaignget->getLastError());
}
/**
 * Samples for Campaignexecute ServiceType
 */
$campaignexecute = new \ServiceType\Campaignexecute($options);
/**
 * Sample call for campaign_execute operation/method
 */
if ($campaignexecute->campaign_execute(new \StructType\Campaign_execute()) !== false) {
    print_r($campaignexecute->getResult());
} else {
    print_r($campaignexecute->getLastError());
}
/**
 * Sample call for campaign_executeAsync operation/method
 */
if ($campaignexecute->campaign_executeAsync(new \StructType\Campaign_executeAsync()) !== false) {
    print_r($campaignexecute->getResult());
} else {
    print_r($campaignexecute->getLastError());
}
/**
 * Samples for Campaignhas ServiceType
 */
$campaignhas = new \ServiceType\Campaignhas($options);
/**
 * Sample call for campaign_hasMember operation/method
 */
if ($campaignhas->campaign_hasMember(new \StructType\Campaign_hasMember()) !== false) {
    print_r($campaignhas->getResult());
} else {
    print_r($campaignhas->getLastError());
}
/**
 * Samples for Campaignadd ServiceType
 */
$campaignadd = new \ServiceType\Campaignadd($options);
/**
 * Sample call for campaign_addMember operation/method
 */
if ($campaignadd->campaign_addMember(new \StructType\Campaign_addMember()) !== false) {
    print_r($campaignadd->getResult());
} else {
    print_r($campaignadd->getLastError());
}
/**
 * Samples for Campaignremove ServiceType
 */
$campaignremove = new \ServiceType\Campaignremove($options);
/**
 * Sample call for campaign_removeMember operation/method
 */
if ($campaignremove->campaign_removeMember(new \StructType\Campaign_removeMember()) !== false) {
    print_r($campaignremove->getResult());
} else {
    print_r($campaignremove->getLastError());
}
/**
 * Samples for Clickget ServiceType
 */
$clickget = new \ServiceType\Clickget($options);
/**
 * Sample call for click_getById operation/method
 */
if ($clickget->click_getById(new \StructType\Click_getById()) !== false) {
    print_r($clickget->getResult());
} else {
    print_r($clickget->getLastError());
}
/**
 * Samples for Mailingget ServiceType
 */
$mailingget = new \ServiceType\Mailingget($options);
/**
 * Sample call for mailing_getComplaintSet operation/method
 */
if ($mailingget->mailing_getComplaintSet(new \StructType\Mailing_getComplaintSet()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getDeliverySet operation/method
 */
if ($mailingget->mailing_getDeliverySet(new \StructType\Mailing_getDeliverySet()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getByCampaignObjectId operation/method
 */
if ($mailingget->mailing_getByCampaignObjectId(new \StructType\Mailing_getByCampaignObjectId()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getByDate operation/method
 */
if ($mailingget->mailing_getByDate(new \StructType\Mailing_getByDate()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getAll operation/method
 */
if ($mailingget->mailing_getAll(new \StructType\Mailing_getAll()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getById operation/method
 */
if ($mailingget->mailing_getById(new \StructType\Mailing_getById()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getQuickmails operation/method
 */
if ($mailingget->mailing_getQuickmails(new \StructType\Mailing_getQuickmails()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getQuickmailsByDate operation/method
 */
if ($mailingget->mailing_getQuickmailsByDate(new \StructType\Mailing_getQuickmailsByDate()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getOpenSet operation/method
 */
if ($mailingget->mailing_getOpenSet(new \StructType\Mailing_getOpenSet()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Sample call for mailing_getBounceSet operation/method
 */
if ($mailingget->mailing_getBounceSet(new \StructType\Mailing_getBounceSet()) !== false) {
    print_r($mailingget->getResult());
} else {
    print_r($mailingget->getLastError());
}
/**
 * Samples for Bounce ServiceType
 */
$bounce = new \ServiceType\Bounce($options);
/**
 * Sample call for bounceSet_getBounce operation/method
 */
if ($bounce->bounceSet_getBounce(new \StructType\BounceSet_getBounce()) !== false) {
    print_r($bounce->getResult());
} else {
    print_r($bounce->getLastError());
}
/**
 * Sample call for bounceSet_getBounces operation/method
 */
if ($bounce->bounceSet_getBounces(new \StructType\BounceSet_getBounces()) !== false) {
    print_r($bounce->getResult());
} else {
    print_r($bounce->getLastError());
}
/**
 * Sample call for bounceSet_getBounceIds operation/method
 */
if ($bounce->bounceSet_getBounceIds(new \StructType\BounceSet_getBounceIds()) !== false) {
    print_r($bounce->getResult());
} else {
    print_r($bounce->getLastError());
}
/**
 * Samples for Complaint ServiceType
 */
$complaint = new \ServiceType\Complaint($options);
/**
 * Sample call for complaintSet_getComplaint operation/method
 */
if ($complaint->complaintSet_getComplaint(new \StructType\ComplaintSet_getComplaint()) !== false) {
    print_r($complaint->getResult());
} else {
    print_r($complaint->getLastError());
}
/**
 * Sample call for complaintSet_getComplaints operation/method
 */
if ($complaint->complaintSet_getComplaints(new \StructType\ComplaintSet_getComplaints()) !== false) {
    print_r($complaint->getResult());
} else {
    print_r($complaint->getLastError());
}
/**
 * Sample call for complaintSet_getComplaintIds operation/method
 */
if ($complaint->complaintSet_getComplaintIds(new \StructType\ComplaintSet_getComplaintIds()) !== false) {
    print_r($complaint->getResult());
} else {
    print_r($complaint->getLastError());
}
/**
 * Samples for Delivery ServiceType
 */
$delivery = new \ServiceType\Delivery($options);
/**
 * Sample call for deliverySet_getDelivery operation/method
 */
if ($delivery->deliverySet_getDelivery(new \StructType\DeliverySet_getDelivery()) !== false) {
    print_r($delivery->getResult());
} else {
    print_r($delivery->getLastError());
}
/**
 * Sample call for deliverySet_getDeliveries operation/method
 */
if ($delivery->deliverySet_getDeliveries(new \StructType\DeliverySet_getDeliveries()) !== false) {
    print_r($delivery->getResult());
} else {
    print_r($delivery->getLastError());
}
/**
 * Samples for Accountadd ServiceType
 */
$accountadd = new \ServiceType\Accountadd($options);
/**
 * Sample call for account_addToCustomer operation/method
 */
if ($accountadd->account_addToCustomer(new \StructType\Account_addToCustomer()) !== false) {
    print_r($accountadd->getResult());
} else {
    print_r($accountadd->getLastError());
}
/**
 * Samples for Accountdelete ServiceType
 */
$accountdelete = new \ServiceType\Accountdelete($options);
/**
 * Sample call for account_deleteFromCustomer operation/method
 */
if ($accountdelete->account_deleteFromCustomer(new \StructType\Account_deleteFromCustomer()) !== false) {
    print_r($accountdelete->getResult());
} else {
    print_r($accountdelete->getLastError());
}
/**
 * Samples for Campaign ServiceType
 */
$campaign = new \ServiceType\Campaign($options);
/**
 * Sample call for campaignStatistics_getByCampaignId operation/method
 */
if ($campaign->campaignStatistics_getByCampaignId(new \StructType\CampaignStatistics_getByCampaignId()) !== false) {
    print_r($campaign->getResult());
} else {
    print_r($campaign->getLastError());
}
/**
 * Sample call for campaignStatistics_getCustomerSet operation/method
 */
if ($campaign->campaignStatistics_getCustomerSet(new \StructType\CampaignStatistics_getCustomerSet()) !== false) {
    print_r($campaign->getResult());
} else {
    print_r($campaign->getLastError());
}
/**
 * Sample call for campaignObjectStatistics_getByCampaignObjectId operation/method
 */
if ($campaign->campaignObjectStatistics_getByCampaignObjectId(new \StructType\CampaignObjectStatistics_getByCampaignObjectId()) !== false) {
    print_r($campaign->getResult());
} else {
    print_r($campaign->getLastError());
}
/**
 * Sample call for campaignObjectStatisticsOption_getCustomerSet operation/method
 */
if ($campaign->campaignObjectStatisticsOption_getCustomerSet(new \StructType\CampaignObjectStatisticsOption_getCustomerSet()) !== false) {
    print_r($campaign->getResult());
} else {
    print_r($campaign->getLastError());
}
/**
 * Samples for Customerinsert ServiceType
 */
$customerinsert = new \ServiceType\Customerinsert($options);
/**
 * Sample call for customer_insertBulkUnique operation/method
 */
if ($customerinsert->customer_insertBulkUnique(new \StructType\Customer_insertBulkUnique()) !== false) {
    print_r($customerinsert->getResult());
} else {
    print_r($customerinsert->getLastError());
}
/**
 * Sample call for customer_insert operation/method
 */
if ($customerinsert->customer_insert(new \StructType\Customer_insert()) !== false) {
    print_r($customerinsert->getResult());
} else {
    print_r($customerinsert->getLastError());
}
/**
 * Sample call for customer_insertUnique operation/method
 */
if ($customerinsert->customer_insertUnique(new \StructType\Customer_insertUnique()) !== false) {
    print_r($customerinsert->getResult());
} else {
    print_r($customerinsert->getLastError());
}
/**
 * Samples for Customercreate ServiceType
 */
$customercreate = new \ServiceType\Customercreate($options);
/**
 * Sample call for customer_create operation/method
 */
if ($customercreate->customer_create(new \StructType\Customer_create()) !== false) {
    print_r($customercreate->getResult());
} else {
    print_r($customercreate->getLastError());
}
/**
 * Samples for Customerupdate ServiceType
 */
$customerupdate = new \ServiceType\Customerupdate($options);
/**
 * Sample call for customer_update operation/method
 */
if ($customerupdate->customer_update(new \StructType\Customer_update()) !== false) {
    print_r($customerupdate->getResult());
} else {
    print_r($customerupdate->getLastError());
}
/**
 * Samples for Customerget ServiceType
 */
$customerget = new \ServiceType\Customerget($options);
/**
 * Sample call for customer_getById operation/method
 */
if ($customerget->customer_getById(new \StructType\Customer_getById()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getByAccountId operation/method
 */
if ($customerget->customer_getByAccountId(new \StructType\Customer_getByAccountId()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getGroups operation/method
 */
if ($customerget->customer_getGroups(new \StructType\Customer_getGroups()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getAll operation/method
 */
if ($customerget->customer_getAll(new \StructType\Customer_getAll()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getByObject operation/method
 */
if ($customerget->customer_getByObject(new \StructType\Customer_getByObject()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getByEmailAddress operation/method
 */
if ($customerget->customer_getByEmailAddress(new \StructType\Customer_getByEmailAddress()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getByMobilePhone operation/method
 */
if ($customerget->customer_getByMobilePhone(new \StructType\Customer_getByMobilePhone()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getByExternalId operation/method
 */
if ($customerget->customer_getByExternalId(new \StructType\Customer_getByExternalId()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getByUserNameAndPassword operation/method
 */
if ($customerget->customer_getByUserNameAndPassword(new \StructType\Customer_getByUserNameAndPassword()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Sample call for customer_getTotalNumberOfCustomers operation/method
 */
if ($customerget->customer_getTotalNumberOfCustomers(new \StructType\Customer_getTotalNumberOfCustomers()) !== false) {
    print_r($customerget->getResult());
} else {
    print_r($customerget->getLastError());
}
/**
 * Samples for Customerdelete ServiceType
 */
$customerdelete = new \ServiceType\Customerdelete($options);
/**
 * Sample call for customer_delete operation/method
 */
if ($customerdelete->customer_delete(new \StructType\Customer_delete()) !== false) {
    print_r($customerdelete->getResult());
} else {
    print_r($customerdelete->getLastError());
}
/**
 * Samples for Customerupsert ServiceType
 */
$customerupsert = new \ServiceType\Customerupsert($options);
/**
 * Sample call for customer_upsert operation/method
 */
if ($customerupsert->customer_upsert(new \StructType\Customer_upsert()) !== false) {
    print_r($customerupsert->getResult());
} else {
    print_r($customerupsert->getLastError());
}
/**
 * Samples for Open ServiceType
 */
$open = new \ServiceType\Open($options);
/**
 * Sample call for openSet_getOpen operation/method
 */
if ($open->openSet_getOpen(new \StructType\OpenSet_getOpen()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Sample call for openSet_getOpens operation/method
 */
if ($open->openSet_getOpens(new \StructType\OpenSet_getOpens()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Sample call for openSet_getOpenIds operation/method
 */
if ($open->openSet_getOpenIds(new \StructType\OpenSet_getOpenIds()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Samples for Conversion ServiceType
 */
$conversion = new \ServiceType\Conversion($options);
/**
 * Sample call for conversionTracking_track operation/method
 */
if ($conversion->conversionTracking_track(new \StructType\ConversionTracking_track()) !== false) {
    print_r($conversion->getResult());
} else {
    print_r($conversion->getLastError());
}
/**
 * Samples for Click ServiceType
 */
$click = new \ServiceType\Click($options);
/**
 * Sample call for clickSet_getClick operation/method
 */
if ($click->clickSet_getClick(new \StructType\ClickSet_getClick()) !== false) {
    print_r($click->getResult());
} else {
    print_r($click->getLastError());
}
/**
 * Sample call for clickSet_getClicks operation/method
 */
if ($click->clickSet_getClicks(new \StructType\ClickSet_getClicks()) !== false) {
    print_r($click->getResult());
} else {
    print_r($click->getLastError());
}
/**
 * Sample call for clickSet_getClickIds operation/method
 */
if ($click->clickSet_getClickIds(new \StructType\ClickSet_getClickIds()) !== false) {
    print_r($click->getResult());
} else {
    print_r($click->getLastError());
}
/**
 * Samples for Bounceget ServiceType
 */
$bounceget = new \ServiceType\Bounceget($options);
/**
 * Sample call for bounce_getById operation/method
 */
if ($bounceget->bounce_getById(new \StructType\Bounce_getById()) !== false) {
    print_r($bounceget->getResult());
} else {
    print_r($bounceget->getLastError());
}
/**
 * Samples for Groupremove ServiceType
 */
$groupremove = new \ServiceType\Groupremove($options);
/**
 * Sample call for group_removeAllMembers operation/method
 */
if ($groupremove->group_removeAllMembers(new \StructType\Group_removeAllMembers()) !== false) {
    print_r($groupremove->getResult());
} else {
    print_r($groupremove->getLastError());
}
/**
 * Sample call for group_removeMember operation/method
 */
if ($groupremove->group_removeMember(new \StructType\Group_removeMember()) !== false) {
    print_r($groupremove->getResult());
} else {
    print_r($groupremove->getLastError());
}
/**
 * Samples for Groupadd ServiceType
 */
$groupadd = new \ServiceType\Groupadd($options);
/**
 * Sample call for group_addMembersInBulk operation/method
 */
if ($groupadd->group_addMembersInBulk(new \StructType\Group_addMembersInBulk()) !== false) {
    print_r($groupadd->getResult());
} else {
    print_r($groupadd->getLastError());
}
/**
 * Sample call for group_addMember operation/method
 */
if ($groupadd->group_addMember(new \StructType\Group_addMember()) !== false) {
    print_r($groupadd->getResult());
} else {
    print_r($groupadd->getLastError());
}
/**
 * Samples for Grouphas ServiceType
 */
$grouphas = new \ServiceType\Grouphas($options);
/**
 * Sample call for group_hasMember operation/method
 */
if ($grouphas->group_hasMember(new \StructType\Group_hasMember()) !== false) {
    print_r($grouphas->getResult());
} else {
    print_r($grouphas->getLastError());
}
/**
 * Samples for Groupget ServiceType
 */
$groupget = new \ServiceType\Groupget($options);
/**
 * Sample call for group_getById operation/method
 */
if ($groupget->group_getById(new \StructType\Group_getById()) !== false) {
    print_r($groupget->getResult());
} else {
    print_r($groupget->getLastError());
}
/**
 * Sample call for group_getMembers operation/method
 */
if ($groupget->group_getMembers(new \StructType\Group_getMembers()) !== false) {
    print_r($groupget->getResult());
} else {
    print_r($groupget->getLastError());
}
/**
 * Sample call for group_getParent operation/method
 */
if ($groupget->group_getParent(new \StructType\Group_getParent()) !== false) {
    print_r($groupget->getResult());
} else {
    print_r($groupget->getLastError());
}
/**
 * Sample call for group_getByObject operation/method
 */
if ($groupget->group_getByObject(new \StructType\Group_getByObject()) !== false) {
    print_r($groupget->getResult());
} else {
    print_r($groupget->getLastError());
}
/**
 * Sample call for group_getAll operation/method
 */
if ($groupget->group_getAll(new \StructType\Group_getAll()) !== false) {
    print_r($groupget->getResult());
} else {
    print_r($groupget->getLastError());
}
/**
 * Sample call for group_getChildren operation/method
 */
if ($groupget->group_getChildren(new \StructType\Group_getChildren()) !== false) {
    print_r($groupget->getResult());
} else {
    print_r($groupget->getLastError());
}
/**
 * Samples for Groupdelete ServiceType
 */
$groupdelete = new \ServiceType\Groupdelete($options);
/**
 * Sample call for group_delete operation/method
 */
if ($groupdelete->group_delete(new \StructType\Group_delete()) !== false) {
    print_r($groupdelete->getResult());
} else {
    print_r($groupdelete->getLastError());
}
/**
 * Samples for Groupupdate ServiceType
 */
$groupupdate = new \ServiceType\Groupupdate($options);
/**
 * Sample call for group_update operation/method
 */
if ($groupupdate->group_update(new \StructType\Group_update()) !== false) {
    print_r($groupupdate->getResult());
} else {
    print_r($groupupdate->getLastError());
}
/**
 * Samples for Groupmove ServiceType
 */
$groupmove = new \ServiceType\Groupmove($options);
/**
 * Sample call for group_move operation/method
 */
if ($groupmove->group_move(new \StructType\Group_move()) !== false) {
    print_r($groupmove->getResult());
} else {
    print_r($groupmove->getLastError());
}
/**
 * Samples for Groupcreate ServiceType
 */
$groupcreate = new \ServiceType\Groupcreate($options);
/**
 * Sample call for group_create operation/method
 */
if ($groupcreate->group_create(new \StructType\Group_create()) !== false) {
    print_r($groupcreate->getResult());
} else {
    print_r($groupcreate->getLastError());
}
/**
 * Samples for Groupinsert ServiceType
 */
$groupinsert = new \ServiceType\Groupinsert($options);
/**
 * Sample call for group_insert operation/method
 */
if ($groupinsert->group_insert(new \StructType\Group_insert()) !== false) {
    print_r($groupinsert->getResult());
} else {
    print_r($groupinsert->getLastError());
}
/**
 * Samples for Groupupsert ServiceType
 */
$groupupsert = new \ServiceType\Groupupsert($options);
/**
 * Sample call for group_upsert operation/method
 */
if ($groupupsert->group_upsert(new \StructType\Group_upsert()) !== false) {
    print_r($groupupsert->getResult());
} else {
    print_r($groupupsert->getLastError());
}
/**
 * Samples for Groupcalculate ServiceType
 */
$groupcalculate = new \ServiceType\Groupcalculate($options);
/**
 * Sample call for group_calculate operation/method
 */
if ($groupcalculate->group_calculate(new \StructType\Group_calculate()) !== false) {
    print_r($groupcalculate->getResult());
} else {
    print_r($groupcalculate->getLastError());
}
/**
 * Samples for Magentocustomer ServiceType
 */
$magentocustomer = new \ServiceType\Magentocustomer($options);
/**
 * Sample call for magento_customerInsertBulkUnique operation/method
 */
if ($magentocustomer->magento_customerInsertBulkUnique(new \StructType\Magento_customerInsertBulkUnique()) !== false) {
    print_r($magentocustomer->getResult());
} else {
    print_r($magentocustomer->getLastError());
}
/**
 * Sample call for magento_customerInsertUnique operation/method
 */
if ($magentocustomer->magento_customerInsertUnique(new \StructType\Magento_customerInsertUnique()) !== false) {
    print_r($magentocustomer->getResult());
} else {
    print_r($magentocustomer->getLastError());
}
/**
 * Samples for Magentoget ServiceType
 */
$magentoget = new \ServiceType\Magentoget($options);
/**
 * Sample call for magento_getCampaigns operation/method
 */
if ($magentoget->magento_getCampaigns(new \StructType\Magento_getCampaigns()) !== false) {
    print_r($magentoget->getResult());
} else {
    print_r($magentoget->getLastError());
}
/**
 * Sample call for magento_getAvailableCustomerFields operation/method
 */
if ($magentoget->magento_getAvailableCustomerFields(new \StructType\Magento_getAvailableCustomerFields()) !== false) {
    print_r($magentoget->getResult());
} else {
    print_r($magentoget->getLastError());
}
/**
 * Samples for Magentotest ServiceType
 */
$magentotest = new \ServiceType\Magentotest($options);
/**
 * Sample call for magento_testConnection operation/method
 */
if ($magentotest->magento_testConnection(new \StructType\Magento_testConnection()) !== false) {
    print_r($magentotest->getResult());
} else {
    print_r($magentotest->getLastError());
}
/**
 * Samples for Magentoexecute ServiceType
 */
$magentoexecute = new \ServiceType\Magentoexecute($options);
/**
 * Sample call for magento_executeAbandonedCart operation/method
 */
if ($magentoexecute->magento_executeAbandonedCart(new \StructType\Magento_executeAbandonedCart()) !== false) {
    print_r($magentoexecute->getResult());
} else {
    print_r($magentoexecute->getLastError());
}
