<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagentoProduct StructType
 * @subpackage Structs
 */
class MagentoProduct extends AbstractStructBase
{
    /**
     * The storeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $storeId;
    /**
     * The orderItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $orderItemId;
    /**
     * The attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOption
     */
    public $attributes;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $id;
    /**
     * The externalProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $externalProductId;
    /**
     * The sku
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $sku;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $description;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $url;
    /**
     * The image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\_string
     */
    public $image;
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $orderId;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Long
     */
    public $quantity;
    /**
     * The priceEx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $priceEx;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $price;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $discount;
    /**
     * The categories
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMagentoCategory
     */
    public $categories;
    /**
     * The related
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $related;
    /**
     * The upSell
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $upSell;
    /**
     * The crossSell
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $crossSell;
    /**
     * The taxPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $taxPercent;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Double
     */
    public $taxAmount;
    /**
     * Constructor method for MagentoProduct
     * @uses MagentoProduct::setStoreId()
     * @uses MagentoProduct::setOrderItemId()
     * @uses MagentoProduct::setAttributes()
     * @uses MagentoProduct::setId()
     * @uses MagentoProduct::setExternalProductId()
     * @uses MagentoProduct::setSku()
     * @uses MagentoProduct::setName()
     * @uses MagentoProduct::setDescription()
     * @uses MagentoProduct::setUrl()
     * @uses MagentoProduct::setImage()
     * @uses MagentoProduct::setOrderId()
     * @uses MagentoProduct::setQuantity()
     * @uses MagentoProduct::setPriceEx()
     * @uses MagentoProduct::setPrice()
     * @uses MagentoProduct::setDiscount()
     * @uses MagentoProduct::setCategories()
     * @uses MagentoProduct::setRelated()
     * @uses MagentoProduct::setUpSell()
     * @uses MagentoProduct::setCrossSell()
     * @uses MagentoProduct::setTaxPercent()
     * @uses MagentoProduct::setTaxAmount()
     * @param \StructType\Long $storeId
     * @param \StructType\Long $orderItemId
     * @param \ArrayType\ArrayOfOption $attributes
     * @param \StructType\Long $id
     * @param \StructType\Long $externalProductId
     * @param \StructType\_string $sku
     * @param \StructType\_string $name
     * @param \StructType\_string $description
     * @param \StructType\_string $url
     * @param \StructType\_string $image
     * @param \StructType\Long $orderId
     * @param \StructType\Long $quantity
     * @param \StructType\Double $priceEx
     * @param \StructType\Double $price
     * @param \StructType\Double $discount
     * @param \ArrayType\ArrayOfMagentoCategory $categories
     * @param \ArrayType\ArrayOfInt $related
     * @param \ArrayType\ArrayOfInt $upSell
     * @param \ArrayType\ArrayOfInt $crossSell
     * @param \StructType\Double $taxPercent
     * @param \StructType\Double $taxAmount
     */
    public function __construct(\StructType\Long $storeId = null, \StructType\Long $orderItemId = null, \ArrayType\ArrayOfOption $attributes = null, \StructType\Long $id = null, \StructType\Long $externalProductId = null, \StructType\_string $sku = null, \StructType\_string $name = null, \StructType\_string $description = null, \StructType\_string $url = null, \StructType\_string $image = null, \StructType\Long $orderId = null, \StructType\Long $quantity = null, \StructType\Double $priceEx = null, \StructType\Double $price = null, \StructType\Double $discount = null, \ArrayType\ArrayOfMagentoCategory $categories = null, \ArrayType\ArrayOfInt $related = null, \ArrayType\ArrayOfInt $upSell = null, \ArrayType\ArrayOfInt $crossSell = null, \StructType\Double $taxPercent = null, \StructType\Double $taxAmount = null)
    {
        $this
            ->setStoreId($storeId)
            ->setOrderItemId($orderItemId)
            ->setAttributes($attributes)
            ->setId($id)
            ->setExternalProductId($externalProductId)
            ->setSku($sku)
            ->setName($name)
            ->setDescription($description)
            ->setUrl($url)
            ->setImage($image)
            ->setOrderId($orderId)
            ->setQuantity($quantity)
            ->setPriceEx($priceEx)
            ->setPrice($price)
            ->setDiscount($discount)
            ->setCategories($categories)
            ->setRelated($related)
            ->setUpSell($upSell)
            ->setCrossSell($crossSell)
            ->setTaxPercent($taxPercent)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get storeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getStoreId()
    {
        return isset($this->storeId) ? $this->storeId : null;
    }
    /**
     * Set storeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $storeId
     * @return \StructType\MagentoProduct
     */
    public function setStoreId(\StructType\Long $storeId = null)
    {
        if (is_null($storeId) || (is_array($storeId) && empty($storeId))) {
            unset($this->storeId);
        } else {
            $this->storeId = $storeId;
        }
        return $this;
    }
    /**
     * Get orderItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getOrderItemId()
    {
        return isset($this->orderItemId) ? $this->orderItemId : null;
    }
    /**
     * Set orderItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $orderItemId
     * @return \StructType\MagentoProduct
     */
    public function setOrderItemId(\StructType\Long $orderItemId = null)
    {
        if (is_null($orderItemId) || (is_array($orderItemId) && empty($orderItemId))) {
            unset($this->orderItemId);
        } else {
            $this->orderItemId = $orderItemId;
        }
        return $this;
    }
    /**
     * Get attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOption|null
     */
    public function getAttributes()
    {
        return isset($this->attributes) ? $this->attributes : null;
    }
    /**
     * Set attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOption $attributes
     * @return \StructType\MagentoProduct
     */
    public function setAttributes(\ArrayType\ArrayOfOption $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->attributes);
        } else {
            $this->attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $id
     * @return \StructType\MagentoProduct
     */
    public function setId(\StructType\Long $id = null)
    {
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get externalProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getExternalProductId()
    {
        return isset($this->externalProductId) ? $this->externalProductId : null;
    }
    /**
     * Set externalProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $externalProductId
     * @return \StructType\MagentoProduct
     */
    public function setExternalProductId(\StructType\Long $externalProductId = null)
    {
        if (is_null($externalProductId) || (is_array($externalProductId) && empty($externalProductId))) {
            unset($this->externalProductId);
        } else {
            $this->externalProductId = $externalProductId;
        }
        return $this;
    }
    /**
     * Get sku value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getSku()
    {
        return isset($this->sku) ? $this->sku : null;
    }
    /**
     * Set sku value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $sku
     * @return \StructType\MagentoProduct
     */
    public function setSku(\StructType\_string $sku = null)
    {
        if (is_null($sku) || (is_array($sku) && empty($sku))) {
            unset($this->sku);
        } else {
            $this->sku = $sku;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $name
     * @return \StructType\MagentoProduct
     */
    public function setName(\StructType\_string $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $description
     * @return \StructType\MagentoProduct
     */
    public function setDescription(\StructType\_string $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getUrl()
    {
        return isset($this->url) ? $this->url : null;
    }
    /**
     * Set url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $url
     * @return \StructType\MagentoProduct
     */
    public function setUrl(\StructType\_string $url = null)
    {
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->url);
        } else {
            $this->url = $url;
        }
        return $this;
    }
    /**
     * Get image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\_string|null
     */
    public function getImage()
    {
        return isset($this->image) ? $this->image : null;
    }
    /**
     * Set image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\_string $image
     * @return \StructType\MagentoProduct
     */
    public function setImage(\StructType\_string $image = null)
    {
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->image);
        } else {
            $this->image = $image;
        }
        return $this;
    }
    /**
     * Get orderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getOrderId()
    {
        return isset($this->orderId) ? $this->orderId : null;
    }
    /**
     * Set orderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $orderId
     * @return \StructType\MagentoProduct
     */
    public function setOrderId(\StructType\Long $orderId = null)
    {
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->orderId);
        } else {
            $this->orderId = $orderId;
        }
        return $this;
    }
    /**
     * Get quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Long|null
     */
    public function getQuantity()
    {
        return isset($this->quantity) ? $this->quantity : null;
    }
    /**
     * Set quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Long $quantity
     * @return \StructType\MagentoProduct
     */
    public function setQuantity(\StructType\Long $quantity = null)
    {
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->quantity);
        } else {
            $this->quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get priceEx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getPriceEx()
    {
        return isset($this->priceEx) ? $this->priceEx : null;
    }
    /**
     * Set priceEx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $priceEx
     * @return \StructType\MagentoProduct
     */
    public function setPriceEx(\StructType\Double $priceEx = null)
    {
        if (is_null($priceEx) || (is_array($priceEx) && empty($priceEx))) {
            unset($this->priceEx);
        } else {
            $this->priceEx = $priceEx;
        }
        return $this;
    }
    /**
     * Get price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getPrice()
    {
        return isset($this->price) ? $this->price : null;
    }
    /**
     * Set price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $price
     * @return \StructType\MagentoProduct
     */
    public function setPrice(\StructType\Double $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->price);
        } else {
            $this->price = $price;
        }
        return $this;
    }
    /**
     * Get discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getDiscount()
    {
        return isset($this->discount) ? $this->discount : null;
    }
    /**
     * Set discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $discount
     * @return \StructType\MagentoProduct
     */
    public function setDiscount(\StructType\Double $discount = null)
    {
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->discount);
        } else {
            $this->discount = $discount;
        }
        return $this;
    }
    /**
     * Get categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMagentoCategory|null
     */
    public function getCategories()
    {
        return isset($this->categories) ? $this->categories : null;
    }
    /**
     * Set categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMagentoCategory $categories
     * @return \StructType\MagentoProduct
     */
    public function setCategories(\ArrayType\ArrayOfMagentoCategory $categories = null)
    {
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->categories);
        } else {
            $this->categories = $categories;
        }
        return $this;
    }
    /**
     * Get related value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRelated()
    {
        return isset($this->related) ? $this->related : null;
    }
    /**
     * Set related value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $related
     * @return \StructType\MagentoProduct
     */
    public function setRelated(\ArrayType\ArrayOfInt $related = null)
    {
        if (is_null($related) || (is_array($related) && empty($related))) {
            unset($this->related);
        } else {
            $this->related = $related;
        }
        return $this;
    }
    /**
     * Get upSell value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getUpSell()
    {
        return isset($this->upSell) ? $this->upSell : null;
    }
    /**
     * Set upSell value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $upSell
     * @return \StructType\MagentoProduct
     */
    public function setUpSell(\ArrayType\ArrayOfInt $upSell = null)
    {
        if (is_null($upSell) || (is_array($upSell) && empty($upSell))) {
            unset($this->upSell);
        } else {
            $this->upSell = $upSell;
        }
        return $this;
    }
    /**
     * Get crossSell value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getCrossSell()
    {
        return isset($this->crossSell) ? $this->crossSell : null;
    }
    /**
     * Set crossSell value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $crossSell
     * @return \StructType\MagentoProduct
     */
    public function setCrossSell(\ArrayType\ArrayOfInt $crossSell = null)
    {
        if (is_null($crossSell) || (is_array($crossSell) && empty($crossSell))) {
            unset($this->crossSell);
        } else {
            $this->crossSell = $crossSell;
        }
        return $this;
    }
    /**
     * Get taxPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getTaxPercent()
    {
        return isset($this->taxPercent) ? $this->taxPercent : null;
    }
    /**
     * Set taxPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $taxPercent
     * @return \StructType\MagentoProduct
     */
    public function setTaxPercent(\StructType\Double $taxPercent = null)
    {
        if (is_null($taxPercent) || (is_array($taxPercent) && empty($taxPercent))) {
            unset($this->taxPercent);
        } else {
            $this->taxPercent = $taxPercent;
        }
        return $this;
    }
    /**
     * Get taxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Double|null
     */
    public function getTaxAmount()
    {
        return isset($this->taxAmount) ? $this->taxAmount : null;
    }
    /**
     * Set taxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Double $taxAmount
     * @return \StructType\MagentoProduct
     */
    public function setTaxAmount(\StructType\Double $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->taxAmount);
        } else {
            $this->taxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MagentoProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
