<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Smssend ServiceType
 * @subpackage Services
 */
class Smssend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sms_sendToCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_sendToCustomer $parameters
     * @return \StructType\Sms_sendToCustomerResponse|bool
     */
    public function sms_sendToCustomer(\StructType\Sms_sendToCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_sendToCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sms_sendToCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_sendToCustomers $parameters
     * @return \StructType\Sms_sendToCustomersResponse|bool
     */
    public function sms_sendToCustomers(\StructType\Sms_sendToCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_sendToCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sms_sendToProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_sendToProfile $parameters
     * @return \StructType\Sms_sendToProfileResponse|bool
     */
    public function sms_sendToProfile(\StructType\Sms_sendToProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_sendToProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sms_sendToGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sms_sendToGroup $parameters
     * @return \StructType\Sms_sendToGroupResponse|bool
     */
    public function sms_sendToGroup(\StructType\Sms_sendToGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sms_sendToGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Sms_sendToCustomerResponse|\StructType\Sms_sendToCustomersResponse|\StructType\Sms_sendToGroupResponse|\StructType\Sms_sendToProfileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
