<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mailingget ServiceType
 * @subpackage Services
 */
class Mailingget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named mailing_getComplaintSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getComplaintSet $parameters
     * @return \StructType\Mailing_getComplaintSetResponse|bool
     */
    public function mailing_getComplaintSet(\StructType\Mailing_getComplaintSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getComplaintSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getDeliverySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getDeliverySet $parameters
     * @return \StructType\Mailing_getDeliverySetResponse|bool
     */
    public function mailing_getDeliverySet(\StructType\Mailing_getDeliverySet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getDeliverySet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getByCampaignObjectId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getByCampaignObjectId $parameters
     * @return \StructType\Mailing_getByCampaignObjectIdResponse|bool
     */
    public function mailing_getByCampaignObjectId(\StructType\Mailing_getByCampaignObjectId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getByCampaignObjectId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getByDate $parameters
     * @return \StructType\Mailing_getByDateResponse|bool
     */
    public function mailing_getByDate(\StructType\Mailing_getByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getAll $parameters
     * @return \StructType\Mailing_getAllResponse|bool
     */
    public function mailing_getAll(\StructType\Mailing_getAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getById $parameters
     * @return \StructType\Mailing_getByIdResponse|bool
     */
    public function mailing_getById(\StructType\Mailing_getById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getQuickmails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getQuickmails $parameters
     * @return \StructType\Mailing_getQuickmailsResponse|bool
     */
    public function mailing_getQuickmails(\StructType\Mailing_getQuickmails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getQuickmails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getQuickmailsByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getQuickmailsByDate $parameters
     * @return \StructType\Mailing_getQuickmailsByDateResponse|bool
     */
    public function mailing_getQuickmailsByDate(\StructType\Mailing_getQuickmailsByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getQuickmailsByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getOpenSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getOpenSet $parameters
     * @return \StructType\Mailing_getOpenSetResponse|bool
     */
    public function mailing_getOpenSet(\StructType\Mailing_getOpenSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getOpenSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailing_getBounceSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mailing_getBounceSet $parameters
     * @return \StructType\Mailing_getBounceSetResponse|bool
     */
    public function mailing_getBounceSet(\StructType\Mailing_getBounceSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailing_getBounceSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Mailing_getAllResponse|\StructType\Mailing_getBounceSetResponse|\StructType\Mailing_getByCampaignObjectIdResponse|\StructType\Mailing_getByDateResponse|\StructType\Mailing_getByIdResponse|\StructType\Mailing_getComplaintSetResponse|\StructType\Mailing_getDeliverySetResponse|\StructType\Mailing_getOpenSetResponse|\StructType\Mailing_getQuickmailsByDateResponse|\StructType\Mailing_getQuickmailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
