<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mailing ServiceType
 * @subpackage Services
 */
class Mailing extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named mailingLink_getClickSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MailingLink_getClickSet $parameters
     * @return \StructType\MailingLink_getClickSetResponse|bool
     */
    public function mailingLink_getClickSet(\StructType\MailingLink_getClickSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailingLink_getClickSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailingSet_getMailing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MailingSet_getMailing $parameters
     * @return \StructType\MailingSet_getMailingResponse|bool
     */
    public function mailingSet_getMailing(\StructType\MailingSet_getMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailingSet_getMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailingSet_getMailings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MailingSet_getMailings $parameters
     * @return \StructType\MailingSet_getMailingsResponse|bool
     */
    public function mailingSet_getMailings(\StructType\MailingSet_getMailings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailingSet_getMailings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named mailingSet_getMailingIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MailingSet_getMailingIds $parameters
     * @return \StructType\MailingSet_getMailingIdsResponse|bool
     */
    public function mailingSet_getMailingIds(\StructType\MailingSet_getMailingIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->mailingSet_getMailingIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MailingLink_getClickSetResponse|\StructType\MailingSet_getMailingIdsResponse|\StructType\MailingSet_getMailingResponse|\StructType\MailingSet_getMailingsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
