<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Magentocustomer ServiceType
 * @subpackage Services
 */
class Magentocustomer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named magento_customerInsertBulkUnique
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Magento_customerInsertBulkUnique $parameters
     * @return \StructType\Magento_customerInsertBulkUniqueResponse|bool
     */
    public function magento_customerInsertBulkUnique(\StructType\Magento_customerInsertBulkUnique $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magento_customerInsertBulkUnique($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named magento_customerInsertUnique
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Magento_customerInsertUnique $parameters
     * @return \StructType\Magento_customerInsertUniqueResponse|bool
     */
    public function magento_customerInsertUnique(\StructType\Magento_customerInsertUnique $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->magento_customerInsertUnique($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Magento_customerInsertBulkUniqueResponse|\StructType\Magento_customerInsertUniqueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
