<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emailsend ServiceType
 * @subpackage Services
 */
class Emailsend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named email_sendToGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_sendToGroup $parameters
     * @return \StructType\Email_sendToGroupResponse|bool
     */
    public function email_sendToGroup(\StructType\Email_sendToGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_sendToGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named email_sendToProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_sendToProfile $parameters
     * @return \StructType\Email_sendToProfileResponse|bool
     */
    public function email_sendToProfile(\StructType\Email_sendToProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_sendToProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named email_sendToCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_sendToCustomer $parameters
     * @return \StructType\Email_sendToCustomerResponse|bool
     */
    public function email_sendToCustomer(\StructType\Email_sendToCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_sendToCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named email_sendToCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_sendToCustomers $parameters
     * @return \StructType\Email_sendToCustomersResponse|bool
     */
    public function email_sendToCustomers(\StructType\Email_sendToCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_sendToCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Email_sendToCustomerResponse|\StructType\Email_sendToCustomersResponse|\StructType\Email_sendToGroupResponse|\StructType\Email_sendToProfileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
