<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emailhas ServiceType
 * @subpackage Services
 */
class Emailhas extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named email_hasChanged
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_hasChanged $parameters
     * @return \StructType\Email_hasChangedResponse|bool
     */
    public function email_hasChanged(\StructType\Email_hasChanged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_hasChanged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Email_hasChangedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
