<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emailget ServiceType
 * @subpackage Services
 */
class Emailget extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named email_getById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_getById $parameters
     * @return \StructType\Email_getByIdResponse|bool
     */
    public function email_getById(\StructType\Email_getById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_getById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named email_getByObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_getByObject $parameters
     * @return \StructType\Email_getByObjectResponse|bool
     */
    public function email_getByObject(\StructType\Email_getByObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_getByObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named email_getAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Email_getAll $parameters
     * @return \StructType\Email_getAllResponse|bool
     */
    public function email_getAll(\StructType\Email_getAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->email_getAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Email_getAllResponse|\StructType\Email_getByIdResponse|\StructType\Email_getByObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
