<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customerupsert ServiceType
 * @subpackage Services
 */
class Customerupsert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named customer_upsert
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Customer_upsert $parameters
     * @return \StructType\Customer_upsertResponse|bool
     */
    public function customer_upsert(\StructType\Customer_upsert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->customer_upsert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Customer_upsertResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
